/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io.win32;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.win32.FileInfo;
import org.jetbrains.kotlin.com.intellij.util.loader.NativeLibraryLoader;
import org.jetbrains.kotlin.com.intellij.util.system.CpuArch;

public final class IdeaWin32 {
    private static final Logger LOG = Logger.getInstance(IdeaWin32.class);
    private static final boolean TRACE_ENABLED = LOG.isTraceEnabled();
    private static final IdeaWin32 ourInstance;

    private static boolean loadBundledLibrary() throws IOException {
        String name2 = CpuArch.isIntel64() ? "IdeaWin64" : "IdeaWin32";
        URL bundled = IdeaWin32.class.getResource(name2 + ".dll");
        if (bundled == null) {
            return false;
        }
        byte[] content2 = FileUtilRt.loadBytes(bundled.openStream());
        CRC32 crc32 = new CRC32();
        crc32.update(content2, 0, content2.length);
        long hash = Math.abs(crc32.getValue());
        Path file2 = Paths.get(FileUtilRt.getTempDirectory(), name2 + '.' + hash + ".dll");
        if (!Files.exists(file2, new LinkOption[0])) {
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Files.write(file2, content2, new OpenOption[0]);
        }
        System.load(file2.toString());
        return true;
    }

    public static boolean isAvailable() {
        return ourInstance != null;
    }

    @NotNull
    public static IdeaWin32 getInstance() {
        if (!IdeaWin32.isAvailable()) {
            throw new IllegalStateException("Native filesystem for Windows is not loaded");
        }
        IdeaWin32 ideaWin32 = ourInstance;
        if (ideaWin32 == null) {
            IdeaWin32.$$$reportNull$$$0(0);
        }
        return ideaWin32;
    }

    private IdeaWin32() {
        IdeaWin32.initIDs();
    }

    private static native void initIDs();

    @Nullable
    public FileInfo getInfo(@NotNull String path2) {
        if (path2 == null) {
            IdeaWin32.$$$reportNull$$$0(1);
        }
        path2 = path2.replace('/', '\\');
        if (TRACE_ENABLED) {
            LOG.trace("getInfo(" + path2 + ")");
            long t = System.nanoTime();
            FileInfo result2 = this.getInfo0(path2);
            t = (System.nanoTime() - t) / 1000L;
            LOG.trace("  " + t + " mks");
            return result2;
        }
        return this.getInfo0(path2);
    }

    private native FileInfo getInfo0(String var1);

    static {
        IdeaWin32 instance2 = null;
        if (SystemInfoRt.isWindows && Boolean.parseBoolean(System.getProperty("idea.use.native.fs.for.win", "true"))) {
            try {
                if (!IdeaWin32.loadBundledLibrary()) {
                    NativeLibraryLoader.loadPlatformLibrary("IdeaWin32");
                }
                instance2 = new IdeaWin32();
                LOG.info("Native filesystem for Windows is operational");
            }
            catch (Throwable t) {
                LOG.warn("Failed to initialize native filesystem for Windows", t);
            }
        }
        ourInstance = instance2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/win32/IdeaWin32";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/win32/IdeaWin32";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listChildren";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

