/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core;

import io.usethesource.capsule.BinaryRelation;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.core.PersistentBidirectionalTrieSetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;

class TransientBidirectionalTrieSetMultimap<K, V>
implements BinaryRelation.Transient<K, V> {
    private final SetMultimap.Transient<K, V> fwd;
    private final transient SetMultimap.Transient<V, K> bwd;

    public TransientBidirectionalTrieSetMultimap(SetMultimap.Transient<K, V> fwd, SetMultimap.Transient<V, K> bwd) {
        this.fwd = fwd;
        this.bwd = bwd;
    }

    private static <K, V> boolean wireTransientTuple(K key, V value, BiFunction<K, V, Boolean> fwdMerger, BiFunction<V, K, Boolean> bwdMerger) {
        boolean fwdResult = fwdMerger.apply(key, value);
        boolean bwdResult = bwdMerger.apply(value, key);
        return fwdResult || bwdResult;
    }

    @Override
    public BinaryRelation.Transient<V, K> inverse() {
        return new TransientBidirectionalTrieSetMultimap<V, K>(this.bwd, this.fwd);
    }

    @Override
    public SetMultimap<K, V> toSetMultimap() {
        return this.fwd;
    }

    @Override
    public int size() {
        return this.fwd.size();
    }

    @Override
    public int sizeDistinct() {
        return this.fwd.sizeDistinct();
    }

    @Override
    public boolean isEmpty() {
        return this.fwd.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.fwd.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.bwd.containsKey(o);
    }

    @Override
    public boolean containsEntry(Object o0, Object o1) {
        return this.fwd.containsEntry(o0, o1);
    }

    @Override
    public Set.Immutable<V> get(Object o) {
        return this.fwd.get(o);
    }

    @Override
    public Set<K> keySet() {
        return this.fwd.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.fwd.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.fwd.entrySet();
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.fwd.keyIterator();
    }

    @Override
    public Iterator<V> valueIterator() {
        return this.fwd.valueIterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return this.fwd.entryIterator();
    }

    @Override
    public Iterator<Map.Entry<K, Object>> nativeEntryIterator() throws UnsupportedOperationException {
        return this.fwd.nativeEntryIterator();
    }

    @Override
    public <T> Iterator<T> tupleIterator(BiFunction<K, V, T> dataConverter) {
        return this.fwd.tupleIterator(dataConverter);
    }

    @Override
    public <T> Stream<T> tupleStream(BiFunction<K, V, T> dataConverter) {
        return this.fwd.tupleStream(dataConverter);
    }

    @Override
    public boolean __put(K key, V value) {
        return TransientBidirectionalTrieSetMultimap.wireTransientTuple(key, value, this.fwd::__put, this.bwd::__put);
    }

    @Override
    public boolean __insert(K key, V value) {
        return TransientBidirectionalTrieSetMultimap.wireTransientTuple(key, value, this.fwd::__insert, this.bwd::__insert);
    }

    @Override
    public boolean __remove(K key, V value) {
        return TransientBidirectionalTrieSetMultimap.wireTransientTuple(key, value, this.fwd::__remove, this.bwd::__remove);
    }

    @Override
    public int hashCode() {
        return this.fwd.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this.fwd.equals(other);
    }

    public String toString() {
        return this.fwd.toString();
    }

    @Override
    public BinaryRelation.Immutable<K, V> freeze() {
        return new PersistentBidirectionalTrieSetMultimap<K, V>(this.fwd.freeze(), this.bwd.freeze());
    }
}

