/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemCategory;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.internal.DefaultProblemCategory;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;

public class DefaultTypeValidationContext
extends ProblemRecordingTypeValidationContext {
    public static final String MISSING_NORMALIZATION_ANNOTATION = "MISSING_NORMALIZATION_ANNOTATION";
    private final boolean reportCacheabilityProblems;
    private final ImmutableList.Builder<Problem> problems = ImmutableList.builder();
    public static final String MISSING_NORMALIZATION_CATEGORY_DETAILS = "property:missing-normalization-annotation";
    public static final DefaultProblemCategory MISSING_NORMALIZATION_CATEGORY = new DefaultProblemCategory("validation:property:missing-normalization-annotation");

    public static DefaultTypeValidationContext withRootType(Class<?> rootType, boolean cacheable) {
        return new DefaultTypeValidationContext(rootType, cacheable);
    }

    public static DefaultTypeValidationContext withoutRootType(Problems problems, boolean reportCacheabilityProblems) {
        return new DefaultTypeValidationContext(null, reportCacheabilityProblems);
    }

    private DefaultTypeValidationContext(@Nullable Class<?> rootType, boolean reportCacheabilityProblems) {
        super(rootType, Optional::empty);
        this.reportCacheabilityProblems = reportCacheabilityProblems;
    }

    public static boolean onlyAffectsCacheableWork(ProblemCategory problemCategory) {
        return MISSING_NORMALIZATION_CATEGORY.equals((Object)problemCategory);
    }

    @Override
    protected void recordProblem(ReportableProblem problem) {
        if (DefaultTypeValidationContext.onlyAffectsCacheableWork(problem.getProblemCategory()) && !this.reportCacheabilityProblems) {
            return;
        }
        this.problems.add((Object)problem);
    }

    public ImmutableList<Problem> getProblems() {
        return this.problems.build();
    }

    public static void throwOnProblemsOf(Class<?> implementation, ImmutableList<Problem> validationMessages) {
        if (!validationMessages.isEmpty()) {
            String formatString = validationMessages.size() == 1 ? "A problem was found with the configuration of %s." : "Some problems were found with the configuration of %s.";
            throw new DefaultMultiCauseException(String.format(formatString, ModelType.of(implementation).getDisplayName()), (Iterable)validationMessages.stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
    }
}

