/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.InPlaceClasspathBuilder;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForAgent;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactoryForLegacy;
import org.gradle.internal.classpath.transforms.InstrumentingClassTransform;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.file.Stat;
import org.gradle.util.internal.GFileUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Instrumented jars are too big to cache")
public abstract class BaseInstrumentingArtifactTransform
implements TransformAction<InstrumentArtifactTransformParameters> {
    @Inject
    public abstract ObjectFactory getObjects();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInput();

    public void transform(TransformOutputs outputs) {
        File input = ((FileSystemLocation)this.getInput().get()).getAsFile();
        if (!input.exists()) {
            return;
        }
        this.createNewFile(outputs.file((Object)".gradle-instrumented.marker"));
        InjectedInstrumentationServices injectedServices = (InjectedInstrumentationServices)this.getObjects().newInstance(InjectedInstrumentationServices.class, new Object[0]);
        File outputFile = outputs.file((Object)("instrumented/" + input.getName()));
        ClasspathElementTransformFactory transformFactory = injectedServices.getTransformFactory((Boolean)((InstrumentArtifactTransformParameters)this.getParameters()).getAgentSupported().get());
        ClasspathElementTransform transform = transformFactory.createTransformer(input, new InstrumentingClassTransform(), InstrumentingTypeRegistry.EMPTY);
        transform.transform(outputFile);
        if (input.isDirectory()) {
            outputs.dir(this.getInput());
        } else if (injectedServices.getGlobalCacheLocations().isInsideGlobalCache(input.getAbsolutePath())) {
            outputs.file(this.getInput());
        } else {
            File copyOfOriginalFile = outputs.file((Object)("original/" + input.getName()));
            GFileUtils.copyFile((File)input, (File)copyOfOriginalFile);
        }
    }

    private boolean createNewFile(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class InjectedInstrumentationServices {
        private final ClasspathElementTransformFactoryForAgent transformFactory;
        private final ClasspathElementTransformFactoryForLegacy legacyTransformFactory;
        private final GlobalCacheLocations globalCacheLocations;

        @Inject
        public InjectedInstrumentationServices(Stat stat, GlobalCacheLocations globalCacheLocations) {
            this.transformFactory = new ClasspathElementTransformFactoryForAgent(new InPlaceClasspathBuilder(), new ClasspathWalker(stat));
            this.legacyTransformFactory = new ClasspathElementTransformFactoryForLegacy(new InPlaceClasspathBuilder(), new ClasspathWalker(stat));
            this.globalCacheLocations = globalCacheLocations;
        }

        public ClasspathElementTransformFactory getTransformFactory(boolean isAgentSupported) {
            return isAgentSupported ? this.transformFactory : this.legacyTransformFactory;
        }

        public GlobalCacheLocations getGlobalCacheLocations() {
            return this.globalCacheLocations;
        }
    }

    public static interface InstrumentArtifactTransformParameters
    extends TransformParameters {
        @Input
        public Property<Boolean> getAgentSupported();
    }
}

