/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.transform.AmbiguousArtifactTransformException;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.AbstractVariantSelectionException;
import org.gradle.internal.component.AmbiguousArtifactVariantsException;
import org.gradle.internal.component.AmbiguousGraphVariantsException;
import org.gradle.internal.component.ArtifactVariantSelectionException;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.ConfigurationNotConsumableException;
import org.gradle.internal.component.ConfigurationNotFoundException;
import org.gradle.internal.component.ExternalConfigurationNotFoundException;
import org.gradle.internal.component.IncompatibleArtifactVariantsException;
import org.gradle.internal.component.IncompatibleGraphVariantsException;
import org.gradle.internal.component.NoMatchingArtifactVariantsException;
import org.gradle.internal.component.NoMatchingCapabilitiesException;
import org.gradle.internal.component.NoMatchingGraphVariantsException;
import org.gradle.internal.component.StyledDescriber;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class ResolutionFailureHandler {
    public static final String DEFAULT_MESSAGE_PREFIX = "Review the variant matching algorithm at ";
    private static final String AMBIGUOUS_VARIANTS_PREFIX = "Ambiguity errors are explained in more detail at ";
    private static final String INCOMPATIBLE_VARIANTS_PREFIX = "Incompatible variant errors are explained in more detail at ";
    private static final String NO_MATCHING_VARIANTS_PREFIX = "No matching variant errors are explained in more detail at ";
    private static final String AMBIGUOUS_TRANSFORMATION_PREFIX = "Transformation failures are explained in more detail at ";
    private static final String AMBIGUOUS_VARIANTS_SECTION = "sub:variant-ambiguity";
    private static final String NO_MATCHING_VARIANTS_SECTION = "sub:variant-no-match";
    private static final String INCOMPATIBLE_VARIANTS_SECTION = "sub:variant-incompatible";
    private static final String AMBIGUOUS_TRANSFORMATION_SECTION = "sub:transform-ambiguity";
    private final DocumentationRegistry documentationRegistry;

    public ResolutionFailureHandler(DocumentationRegistry documentationRegistry) {
        this.documentationRegistry = documentationRegistry;
    }

    private void suggestSpecificDocumentation(AbstractVariantSelectionException exception, String prefix, String section) {
        exception.addResolution(prefix + this.documentationRegistry.getDocumentationFor("variant_model", section) + ".");
    }

    private void suggestReviewAlgorithm(AbstractVariantSelectionException exception) {
        exception.addResolution(DEFAULT_MESSAGE_PREFIX + this.documentationRegistry.getDocumentationFor("variant_attributes", "sec:abm_algorithm") + ".");
    }

    public NoMatchingArtifactVariantsException noMatchingArtifactVariantFailure(AttributesSchema schema, String displayName, ImmutableAttributes componentRequested, List<? extends ResolvedVariant> variants, AttributeMatcher matcher, AttributeDescriber attributeDescriber) {
        String message = this.buildNoMatchingVariantsFailureMsg(displayName, (AttributeContainerInternal)componentRequested, variants, matcher, attributeDescriber);
        NoMatchingArtifactVariantsException e = new NoMatchingArtifactVariantsException(message);
        this.suggestSpecificDocumentation(e, NO_MATCHING_VARIANTS_PREFIX, NO_MATCHING_VARIANTS_SECTION);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public AmbiguousArtifactVariantsException ambiguousArtifactVariantsFailure(AttributesSchema schema, String displayName, ImmutableAttributes componentRequested, List<? extends ResolvedVariant> matches, AttributeMatcher matcher, Set<ResolvedVariant> discarded, AttributeDescriber attributeDescriber) {
        String message = this.buildMultipleMatchingVariantsFailureMsg(attributeDescriber, displayName, (AttributeContainerInternal)componentRequested, matches, matcher, discarded);
        AmbiguousArtifactVariantsException e = new AmbiguousArtifactVariantsException(message);
        this.suggestSpecificDocumentation(e, AMBIGUOUS_VARIANTS_PREFIX, AMBIGUOUS_VARIANTS_SECTION);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public AmbiguousArtifactTransformException ambiguousArtifactTransformationFailure(AttributesSchema schema, String displayName, ImmutableAttributes componentRequested, List<TransformedVariant> transformedVariants) {
        String message = this.buildAmbiguousTransformMsg(displayName, (AttributeContainerInternal)componentRequested, transformedVariants);
        AmbiguousArtifactTransformException e = new AmbiguousArtifactTransformException(message);
        this.suggestSpecificDocumentation(e, AMBIGUOUS_TRANSFORMATION_PREFIX, AMBIGUOUS_TRANSFORMATION_SECTION);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public BrokenResolvedArtifactSet unknownArtifactVariantSelectionFailure(AttributesSchema schema, ArtifactVariantSelectionException t) {
        BrokenResolvedArtifactSet e = new BrokenResolvedArtifactSet((Throwable)((Object)t));
        return e;
    }

    public BrokenResolvedArtifactSet unknownArtifactVariantSelectionFailure(AttributesSchema schema, ResolvedVariantSet producer, Exception cause) {
        String message = this.buildUnknownArtifactVariantFailureMsg(producer);
        ArtifactVariantSelectionException e = new ArtifactVariantSelectionException(message, cause);
        this.suggestReviewAlgorithm(e);
        return this.unknownArtifactVariantSelectionFailure(schema, e);
    }

    public IncompatibleArtifactVariantsException incompatibleArtifactVariantsFailure(ComponentState selected, Set<NodeState> incompatibleNodes) {
        String message = this.buildIncompatibleArtifactVariantsFailureMsg(selected, incompatibleNodes);
        IncompatibleArtifactVariantsException e = new IncompatibleArtifactVariantsException(message);
        this.suggestSpecificDocumentation(e, INCOMPATIBLE_VARIANTS_PREFIX, INCOMPATIBLE_VARIANTS_SECTION);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    private String buildUnknownArtifactVariantFailureMsg(ResolvedVariantSet producer) {
        return String.format("Could not select a variant of %s that matches the consumer attributes.", producer.asDescribable().getDisplayName());
    }

    private String buildNoMatchingVariantsFailureMsg(String producerDisplayName, AttributeContainerInternal consumer, Collection<? extends ResolvedVariant> candidates, AttributeMatcher matcher, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No variants of " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)producerDisplayName) + " match the consumer attributes");
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : candidates) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            this.formatAttributeMatchesForIncompatibility(formatter, consumer.asImmutable(), matcher, resolvedVariant.getAttributes().asImmutable(), describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private String buildMultipleMatchingVariantsFailureMsg(AttributeDescriber describer, String producerDisplayName, AttributeContainerInternal consumer, List<? extends ResolvedVariant> variants, AttributeMatcher matcher, Set<ResolvedVariant> discarded) {
        TreeFormatter formatter = new TreeFormatter();
        if (consumer.getAttributes().isEmpty()) {
            formatter.node("More than one variant of " + producerDisplayName + " matches the consumer attributes");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(consumer.asMap()) + ". However we cannot choose between the following variants of " + producerDisplayName);
        }
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : variants) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            this.formatAttributeMatchesForAmbiguity(formatter, consumer.asImmutable(), matcher, resolvedVariant.getAttributes().asImmutable(), describer);
        }
        formatter.endChildren();
        if (!discarded.isEmpty()) {
            formatter.node("The following variants were also considered but didn't match the requested attributes:");
            formatter.startChildren();
            discarded.stream().sorted(Comparator.comparing(v -> v.asDescribable().getCapitalizedDisplayName())).forEach(discardedVariant -> {
                formatter.node(discardedVariant.asDescribable().getCapitalizedDisplayName());
                this.formatAttributeMatchesForIncompatibility(formatter, consumer.asImmutable(), matcher, discardedVariant.getAttributes().asImmutable(), describer);
            });
            formatter.endChildren();
        }
        return formatter.toString();
    }

    private String buildAmbiguousTransformMsg(String producerDisplayName, AttributeContainerInternal requested, List<TransformedVariant> candidates) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Found multiple transforms that can produce a variant of " + producerDisplayName + " with requested attributes");
        this.formatSortedAttributes(formatter, (AttributeContainer)requested);
        formatter.node("Found the following transforms");
        Comparator<TransformedVariant> variantComparator = Comparator.comparing(x -> x.getTransformChain().getDisplayName()).thenComparing(x -> x.getAttributes().toString());
        Map variantToTransforms = candidates.stream().collect(Collectors.groupingBy(TransformedVariant::getRoot, () -> new TreeMap(Comparator.comparing(variant -> variant.asDescribable().getDisplayName())), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(variantComparator).collect(Collectors.toList()))));
        formatter.startChildren();
        for (Map.Entry entry : variantToTransforms.entrySet()) {
            formatter.node("From '" + ((ResolvedVariant)entry.getKey()).asDescribable().getDisplayName() + "'");
            formatter.startChildren();
            formatter.node("With source attributes");
            this.formatSortedAttributes(formatter, (AttributeContainer)((ResolvedVariant)entry.getKey()).getAttributes());
            formatter.node("Candidate transform(s)");
            formatter.startChildren();
            for (TransformedVariant variant : (List)entry.getValue()) {
                formatter.node("Transform '" + variant.getTransformChain().getDisplayName() + "' producing attributes:");
                this.formatSortedAttributes(formatter, (AttributeContainer)variant.getAttributes());
            }
            formatter.endChildren();
            formatter.endChildren();
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private void formatSortedAttributes(TreeFormatter formatter, AttributeContainer attributes) {
        formatter.startChildren();
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
        formatter.endChildren();
    }

    private String buildIncompatibleArtifactVariantsFailureMsg(ComponentState selected, Set<NodeState> incompatibleNodes) {
        StringBuilder sb = new StringBuilder("Multiple incompatible variants of ").append(selected.getId()).append(" were selected:\n");
        ArrayList sorted = Lists.newArrayList(incompatibleNodes);
        sorted.sort(Comparator.comparing(NodeState::getNameWithVariant));
        for (NodeState node : sorted) {
            sb.append("   - Variant ").append(node.getNameWithVariant()).append(" has attributes ");
            this.formatAttributes(sb, node.getMetadata().getAttributes());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void formatAttributes(StringBuilder sb, ImmutableAttributes attributes) {
        ImmutableSet keySet = attributes.keySet();
        ArrayList sorted = Lists.newArrayList((Iterable)keySet);
        sorted.sort(Comparator.comparing(Attribute::getName));
        boolean space = false;
        sb.append("{");
        for (Attribute attribute : sorted) {
            if (space) {
                sb.append(", ");
            }
            sb.append(attribute.getName()).append("=").append(attributes.getAttribute(attribute));
            space = true;
        }
        sb.append("}");
    }

    public AmbiguousGraphVariantsException ambiguousGraphVariantsFailure(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends VariantGraphResolveState> matches, ComponentGraphResolveMetadata targetComponent, boolean variantAware, Set<VariantGraphResolveState> discarded) {
        String message = this.buildAmbiguousGraphVariantsFailureMsg(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, matches, targetComponent, variantAware, discarded);
        AmbiguousGraphVariantsException e = new AmbiguousGraphVariantsException(message);
        e.addResolution(AMBIGUOUS_VARIANTS_PREFIX + this.documentationRegistry.getDocumentationFor("variant_model", "sub:variant-ambiguity."));
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public IncompatibleGraphVariantsException incompatibleGraphVariantsFailure(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, ConfigurationGraphResolveState targetConfiguration, boolean variantAware, AttributeDescriber describer) {
        String message = this.buildIncompatibleGraphVariantsFailureMsg(fromConfigurationAttributes, attributeMatcher, targetComponent, targetConfiguration, variantAware, describer);
        IncompatibleGraphVariantsException e = new IncompatibleGraphVariantsException(message);
        e.addResolution(INCOMPATIBLE_VARIANTS_PREFIX + this.documentationRegistry.getDocumentationFor("variant_model", INCOMPATIBLE_VARIANTS_SECTION) + ".");
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public NoMatchingGraphVariantsException noMatchingGraphVariantFailure(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        String message = this.buildNoMatchingGraphVariantSelectionFailureMsg(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, targetComponent, candidates);
        NoMatchingGraphVariantsException e = new NoMatchingGraphVariantsException(message);
        this.suggestReviewAlgorithm(e);
        e.addResolution(NO_MATCHING_VARIANTS_PREFIX + this.documentationRegistry.getDocumentationFor("variant_model", "sub:variant-no-match."));
        return e;
    }

    public NoMatchingCapabilitiesException noMatchingCapabilitiesFailure(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        String message = this.buildNoMatchingCapabilitiesFailureMsg(targetComponent, requestedCapabilities, candidates);
        NoMatchingCapabilitiesException e = new NoMatchingCapabilitiesException(message);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public ConfigurationNotFoundException configurationNotFoundFailure(String targetConfigurationName, ComponentIdentifier targetComponentId) {
        String message = this.buildConfigurationNotFoundFailureMsg(targetConfigurationName, targetComponentId);
        ConfigurationNotFoundException e = new ConfigurationNotFoundException(message);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public ExternalConfigurationNotFoundException externalConfigurationNotFoundFailure(ComponentIdentifier fromComponent, String fromConfiguration, String toConfiguration, ComponentIdentifier toComponent) {
        String message = this.buildExternalConfigurationNotFoundFailureMsg(fromComponent, fromConfiguration, toConfiguration, toComponent);
        ExternalConfigurationNotFoundException e = new ExternalConfigurationNotFoundException(message);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    public ConfigurationNotConsumableException configurationNotConsumableFailure(String targetComponentName, String targetConfigurationName) {
        String message = this.buildConfigurationNotConsumableFailureMsg(targetComponentName, targetConfigurationName);
        ConfigurationNotConsumableException e = new ConfigurationNotConsumableException(message);
        this.suggestReviewAlgorithm(e);
        return e;
    }

    private String buildConfigurationNotFoundFailureMsg(String targetConfigurationName, ComponentIdentifier targetComponentId) {
        return String.format("A dependency was declared on configuration '%s' which is not declared in the descriptor for %s.", targetConfigurationName, targetComponentId.getDisplayName());
    }

    private String buildExternalConfigurationNotFoundFailureMsg(ComponentIdentifier fromComponent, String fromConfiguration, String toConfiguration, ComponentIdentifier toComponent) {
        return String.format("%s declares a dependency from configuration '%s' to configuration '%s' which is not declared in the descriptor for %s.", StringUtils.capitalize((String)fromComponent.getDisplayName()), fromConfiguration, toConfiguration, toComponent.getDisplayName());
    }

    private String buildConfigurationNotConsumableFailureMsg(String targetComponentName, String targetConfigurationName) {
        return String.format("Selected configuration '" + targetConfigurationName + "' on '" + targetComponentName + "' but it can't be used as a project dependency because it isn't intended for consumption by other components.", new Object[0]);
    }

    private String buildAmbiguousGraphVariantsFailureMsg(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends VariantGraphResolveState> matches, ComponentGraphResolveMetadata targetComponent, boolean variantAware, Set<VariantGraphResolveState> discarded) {
        String string;
        TreeMap<String, VariantGraphResolveState> ambiguousVariants = new TreeMap<String, VariantGraphResolveState>();
        for (VariantGraphResolveState variantGraphResolveState : matches) {
            ambiguousVariants.put(variantGraphResolveState.getName(), variantGraphResolveState);
        }
        TreeFormatter formatter = new TreeFormatter();
        String string2 = string = variantAware ? "variants" : "configurations";
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Cannot choose between the following " + string + " of ");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + ". However we cannot choose between the following " + string + " of ");
        }
        formatter.append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName()));
        formatter.startChildren();
        for (String configuration : ambiguousVariants.keySet()) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (VariantGraphResolveState ambiguousVariant : ambiguousVariants.values()) {
            this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, ambiguousVariant.getMetadata(), variantAware, true, describer);
        }
        formatter.endChildren();
        if (!discarded.isEmpty()) {
            formatter.node("The following " + string + " were also considered but didn't match the requested attributes:");
            formatter.startChildren();
            discarded.stream().sorted(Comparator.comparing(VariantGraphResolveState::getName)).forEach(discardedConf -> this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, discardedConf.getMetadata(), variantAware, false, describer));
            formatter.endChildren();
        }
        return formatter.toString();
    }

    private String buildIncompatibleGraphVariantsFailureMsg(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, ConfigurationGraphResolveState targetConfiguration, boolean variantAware, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Configuration '" + targetConfiguration.getName() + "' in " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName()) + " does not match the consumer attributes");
        this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, targetConfiguration.asVariant().getMetadata(), variantAware, false, describer);
        return formatter.toString();
    }

    private String buildNoMatchingGraphVariantSelectionFailureMsg(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        boolean variantAware = candidates.isUseVariants();
        TreeMap<String, VariantGraphResolveMetadata> variants = new TreeMap<String, VariantGraphResolveMetadata>();
        if (variantAware) {
            for (VariantGraphResolveState variantGraphResolveState : candidates.getVariants()) {
                variants.put(variantGraphResolveState.getName(), variantGraphResolveState.getMetadata());
            }
        } else {
            for (ConfigurationGraphResolveMetadata configurationGraphResolveMetadata : candidates.getCandidateConfigurations()) {
                variants.put(configurationGraphResolveMetadata.getName(), configurationGraphResolveMetadata);
            }
        }
        TreeFormatter formatter = new TreeFormatter();
        String string = StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName());
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Unable to find a matching " + (variantAware ? "variant" : "configuration") + " of " + string);
        } else {
            formatter.node("No matching " + (variantAware ? "variant" : "configuration") + " of " + string + " was found. The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + " but:");
        }
        formatter.startChildren();
        if (variants.isEmpty()) {
            formatter.node("None of the " + (variantAware ? "variants" : "consumable configurations") + " have attributes.");
        } else {
            for (VariantGraphResolveMetadata variant : variants.values()) {
                this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, variant, variantAware, false, describer);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private String buildNoMatchingCapabilitiesFailureMsg(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        StringBuilder sb = new StringBuilder("Unable to find a variant of ");
        sb.append(targetComponent.getId()).append(" providing the requested ");
        sb.append(CapabilitiesSupport.prettifyCapabilities(targetComponent, requestedCapabilities));
        sb.append(":\n");
        for (VariantGraphResolveState variantGraphResolveState : candidates) {
            sb.append("   - Variant ").append(variantGraphResolveState.getName()).append(" provides ");
            sb.append(CapabilitiesSupport.sortedCapabilityList(targetComponent, variantGraphResolveState.getCapabilities().asSet())).append("\n");
        }
        return sb.toString();
    }

    private void formatConfiguration(TreeFormatter formatter, ComponentGraphResolveMetadata targetComponent, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, VariantGraphResolveMetadata variant, boolean variantAware, boolean ambiguous, AttributeDescriber describer) {
        ImmutableAttributes producerAttributes = variant.getAttributes();
        if (variantAware) {
            formatter.node("Variant '");
        } else {
            formatter.node("Configuration '");
        }
        formatter.append((CharSequence)variant.getName());
        formatter.append((CharSequence)"'");
        if (variantAware) {
            formatter.append((CharSequence)(" " + CapabilitiesSupport.prettifyCapabilities(targetComponent, variant.getCapabilities().asSet())));
        }
        if (ambiguous) {
            this.formatAttributeMatchesForAmbiguity(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable(), describer);
        } else {
            this.formatAttributeMatchesForIncompatibility(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable(), describer);
        }
    }

    private void formatAttributeMatchesForIncompatibility(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer, AttributeDescriber describer) {
        Map<String, Attribute<?>> allAttributes = this.collectAttributes(immutableConsumer, immutableProducer);
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        LinkedHashMap compatibleAttrs = new LinkedHashMap();
        LinkedHashMap incompatibleAttrs = new LinkedHashMap();
        LinkedHashMap incompatibleConsumerAttrs = new LinkedHashMap();
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    compatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                    continue;
                }
                incompatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                incompatibleConsumerAttrs.put(attribute, Cast.uncheckedCast((Object)consumerValue.get()));
                continue;
            }
            if (!consumerValue.isPresent()) continue;
            otherValues.add("Doesn't say anything about " + describer.describeMissingAttribute(attribute, consumerValue.get()));
        }
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet(compatibleAttrs)));
        }
        formatter.startChildren();
        if (!incompatibleAttrs.isEmpty()) {
            formatter.node("Incompatible because this component declares " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.FailureHeader, (String)describer.describeAttributeSet(incompatibleAttrs)) + " and the consumer needed <FailureHeader>" + describer.describeAttributeSet(incompatibleConsumerAttrs) + "</FailureHeader>");
        }
        this.formatAttributeSection(formatter, "Other compatible attribute", otherValues);
        formatter.endChildren();
    }

    private void formatAttributeMatchesForAmbiguity(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer, AttributeDescriber describer) {
        Map<String, Attribute<?>> allAttributes = this.collectAttributes(immutableConsumer, immutableProducer);
        LinkedHashMap compatibleAttrs = new LinkedHashMap();
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (!attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) continue;
                compatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                continue;
            }
            if (consumerValue.isPresent()) {
                otherValues.add("Doesn't say anything about " + describer.describeMissingAttribute(attribute, consumerValue.get()));
                continue;
            }
            otherValues.add("Provides " + describer.describeExtraAttribute(attribute, producerValue.get()) + " but the consumer didn't ask for it");
        }
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet(compatibleAttrs)));
        }
        formatter.startChildren();
        this.formatAttributeSection(formatter, "Unmatched attribute", otherValues);
        formatter.endChildren();
    }

    private Map<String, Attribute<?>> collectAttributes(ImmutableAttributes consumerAttributes, ImmutableAttributes producerAttributes) {
        TreeMap allAttributes = new TreeMap();
        for (Attribute attribute : producerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : consumerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        return allAttributes;
    }

    private void formatAttributeSection(TreeFormatter formatter, String section, List<String> values) {
        if (!values.isEmpty()) {
            if (values.size() > 1) {
                formatter.node(section + "s");
            } else {
                formatter.node(section);
            }
            formatter.startChildren();
            values.forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
            formatter.endChildren();
        }
    }
}

