/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;

public final class EvaluationContext {
    private static final int EXPECTED_MAX_CONTEXT_SIZE = 64;
    private static final EvaluationContext INSTANCE = new EvaluationContext();
    private final ThreadLocal<PerThreadContext> threadLocalContext = ThreadLocal.withInitial(() -> new PerThreadContext(null));

    public static EvaluationContext current() {
        return INSTANCE;
    }

    private EvaluationContext() {
    }

    public ScopeContext open(EvaluationOwner owner) {
        return this.getContext().open(owner);
    }

    public <R, E extends Exception> R evaluate(EvaluationOwner owner, ScopedEvaluation<? extends R, E> evaluation) throws E {
        try (ScopeContext ignored = this.open(owner);){
            R r = evaluation.evaluate();
            return r;
        }
    }

    public <R, E extends Exception> R tryEvaluate(EvaluationOwner owner, R fallbackValue, ScopedEvaluation<? extends R, E> evaluation) throws E {
        if (this.getContext().isInScope(owner)) {
            return fallbackValue;
        }
        return this.evaluate(owner, evaluation);
    }

    public <R, E extends Exception> R evaluateNested(ScopedEvaluation<? extends R, E> evaluation) throws E {
        try (ScopeContext ignored = this.nested();){
            R r = evaluation.evaluate();
            return r;
        }
    }

    private PerThreadContext getContext() {
        return this.threadLocalContext.get();
    }

    private PerThreadContext setContext(PerThreadContext newContext) {
        this.threadLocalContext.set(newContext);
        return newContext;
    }

    private ScopeContext nested() {
        return this.setContext(new PerThreadContext(this.getContext()));
    }

    public static class CircularEvaluationException
    extends GradleException {
        private final ImmutableList<EvaluationOwner> evaluationCycle;

        CircularEvaluationException(List<EvaluationOwner> evaluationCycle) {
            this.evaluationCycle = ImmutableList.copyOf(evaluationCycle);
        }

        public String getMessage() {
            return "Circular evaluation detected: " + CircularEvaluationException.formatEvaluationChain(this.evaluationCycle);
        }

        public List<EvaluationOwner> getEvaluationCycle() {
            return this.evaluationCycle;
        }

        private static String formatEvaluationChain(List<EvaluationOwner> evaluationCycle) {
            try (ScopeContext ignored = EvaluationContext.current().nested();){
                String string = evaluationCycle.stream().map(CircularEvaluationException::safeToString).collect(Collectors.joining("\n -> "));
                return string;
            }
        }

        private static String safeToString(Object owner) {
            try {
                return owner.toString();
            }
            catch (Throwable e) {
                return owner.getClass().getName() + " (toString failed with " + e.getClass() + ")";
            }
        }
    }

    private final class PerThreadContext
    implements ScopeContext {
        private final Set<EvaluationOwner> objectsInScope = new ReferenceOpenHashSet(64);
        private final List<EvaluationOwner> evaluationStack = new ReferenceArrayList(64);
        @Nullable
        private final PerThreadContext parent;

        public PerThreadContext(PerThreadContext parent) {
            this.parent = parent;
        }

        private void push(EvaluationOwner owner) {
            if (!this.objectsInScope.add(owner)) {
                throw this.prepareException(owner);
            }
            this.evaluationStack.add(owner);
        }

        private void pop() {
            EvaluationOwner removed = this.evaluationStack.remove(this.evaluationStack.size() - 1);
            this.objectsInScope.remove(removed);
        }

        public PerThreadContext open(EvaluationOwner owner) {
            this.push(owner);
            return this;
        }

        @Override
        public void close() {
            if (this.parent != null && this.evaluationStack.isEmpty()) {
                EvaluationContext.this.setContext(this.parent);
                return;
            }
            this.pop();
        }

        public boolean isInScope(EvaluationOwner owner) {
            return this.objectsInScope.contains(owner);
        }

        @Override
        public EvaluationOwner getOwner() {
            Preconditions.checkState((!this.evaluationStack.isEmpty() ? 1 : 0) != 0, (Object)"No object is being evaluated right now");
            return this.evaluationStack.get(this.evaluationStack.size() - 1);
        }

        private CircularEvaluationException prepareException(EvaluationOwner circular) {
            int i = this.evaluationStack.indexOf(circular);
            assert (i >= 0);
            List<EvaluationOwner> preCycleList = this.evaluationStack.subList(i, this.evaluationStack.size());
            ImmutableList evaluationCycle = ImmutableList.builderWithExpectedSize((int)(preCycleList.size() + 1)).addAll(preCycleList).add((Object)circular).build();
            return new CircularEvaluationException((List<EvaluationOwner>)evaluationCycle);
        }
    }

    public static interface ScopeContext
    extends AutoCloseable {
        public EvaluationOwner getOwner();

        @Override
        public void close();
    }

    public static interface EvaluationOwner {
    }

    @FunctionalInterface
    public static interface ScopedEvaluation<R, E extends Exception> {
        public R evaluate() throws E;
    }
}

