/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.execution.steps.AfterExecutionOutputFilter;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class OverlappingOutputsFilter
implements AfterExecutionOutputFilter<BeforeExecutionContext, BeforeExecutionState> {
    @Override
    public Optional<BeforeExecutionState> getBeforeExecutionState(BeforeExecutionContext context) {
        return context.getBeforeExecutionState();
    }

    @Override
    public ImmutableSortedMap<String, FileSystemSnapshot> filterOutputs(BeforeExecutionContext context, BeforeExecutionState beforeExecutionState, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution) {
        if (beforeExecutionState.getDetectedOverlappingOutputs().isPresent()) {
            ImmutableSortedMap previousExecutionOutputSnapshots = context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
            ImmutableSortedMap unfilteredOutputSnapshotsBeforeExecution = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).orElse(ImmutableSortedMap.of());
            return OutputSnapshotUtil.filterOutputsAfterExecution((ImmutableSortedMap<String, FileSystemSnapshot>)previousExecutionOutputSnapshots, (ImmutableSortedMap<String, FileSystemSnapshot>)unfilteredOutputSnapshotsBeforeExecution, unfilteredOutputSnapshotsAfterExecution);
        }
        return unfilteredOutputSnapshotsAfterExecution;
    }
}

