/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.Problem;

public class DiagnosticToProblemListener
implements DiagnosticListener<JavaFileObject> {
    private final InternalProblemReporter problemReporter;

    public DiagnosticToProblemListener(Problems problemsService) {
        this.problemReporter = ((InternalProblems)problemsService).getInternalReporter();
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        String message = diagnostic.getMessage(Locale.getDefault());
        String label = DiagnosticToProblemListener.mapKindToLabel(diagnostic.getKind());
        String resourceName = diagnostic.getSource() != null ? diagnostic.getSource().toUri().toString() : null;
        Integer line = Math.toIntExact(diagnostic.getLineNumber());
        Integer column = Math.toIntExact(diagnostic.getColumnNumber());
        Integer length = Math.toIntExact(diagnostic.getEndPosition() - diagnostic.getStartPosition());
        Severity severity = DiagnosticToProblemListener.mapKindToSeverity(diagnostic.getKind());
        Problem problem = this.problemReporter.create(p -> p.label(label).lineInFileLocation(resourceName, line.intValue(), column.intValue(), length.intValue()).category("compiler", new String[]{"java"}).severity(severity).details(message));
        this.problemReporter.report(problem);
        System.err.println(message);
    }

    private static String mapKindToLabel(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "Java compilation error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "Java compilation warning";
            }
            case NOTE: {
                return "Java compilation note";
            }
            case OTHER: {
                return "Java compilation problem";
            }
        }
        return "Unknown java compilation problem";
    }

    private static Severity mapKindToSeverity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ADVICE;
    }
}

