/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSourceReplacementException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "", "sourceContentResolver", "Lkotlin/Function1;", "", "Ljava/io/Reader;", "(Lkotlin/jvm/functions/Function1;)V", "groups", "", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapGroup;", "getGroups", "()Ljava/util/List;", "getSourceContentResolver", "()Lkotlin/jvm/functions/Function1;", "debug", "", "writer", "Ljava/io/PrintStream;", "debugToString", "debugVerbose", "generatedJsFile", "Ljava/io/File;", "Companion", "js.parser"})
@SourceDebugExtension(value={"SMAP\nSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1#2:115\n37#3,2:116\n1549#4:118\n1620#4,3:119\n*S KotlinDebug\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap\n*L\n40#1:116,2\n44#1:118\n44#1:119,3\n*E\n"})
public final class SourceMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Reader> sourceContentResolver;
    @NotNull
    private final List<SourceMapGroup> groups;

    public SourceMap(@NotNull Function1<? super String, ? extends Reader> sourceContentResolver) {
        Intrinsics.checkNotNullParameter(sourceContentResolver, (String)"sourceContentResolver");
        this.sourceContentResolver = sourceContentResolver;
        this.groups = new ArrayList();
    }

    @NotNull
    public final Function1<String, Reader> getSourceContentResolver() {
        return this.sourceContentResolver;
    }

    @NotNull
    public final List<SourceMapGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    public final String debugToString() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream it = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        this.debug(new PrintStream(it));
        String string2 = byteArrayOutputStream.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final void debug(@NotNull PrintStream writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Iterator<SourceMapGroup> iterator2 = this.groups.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            SourceMapGroup group = iterator2.next();
            writer.print("" + (index2 + 1) + ':');
            for (SourceMapSegment segment : group.getSegments()) {
                String nameIfPresent = segment.getName() != null ? '(' + segment.getName() + ')' : "";
                writer.print("" + ' ' + (segment.getGeneratedColumnNumber() + 1) + ':' + (segment.getSourceLineNumber() + 1) + ',' + (segment.getSourceColumnNumber() + 1) + nameIfPresent);
            }
            writer.println();
        }
    }

    public static /* synthetic */ void debug$default(SourceMap sourceMap2, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"out");
            printStream = printStream2;
        }
        sourceMap2.debug(printStream);
    }

    /*
     * WARNING - void declaration
     */
    public final void debugVerbose(@NotNull PrintStream writer, @NotNull File generatedJsFile) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)generatedJsFile, (String)"generatedJsFile");
        boolean bl = generatedJsFile.exists();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SourceMap$debugVerbose$22 = false;
            String $i$a$-assert-SourceMap$debugVerbose$22 = generatedJsFile + " does not exist!";
            throw new AssertionError((Object)$i$a$-assert-SourceMap$debugVerbose$22);
        }
        Collection $this$toTypedArray$iv = FilesKt.readLines$default((File)generatedJsFile, null, (int)1, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] generatedLines = thisCollection$iv.toArray(new String[0]);
        Iterator<SourceMapGroup> iterator2 = this.groups.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            int index2 = n++;
            SourceMapGroup group = iterator2.next();
            writer.print("" + (index2 + 1) + ':');
            String generatedLine = generatedLines[index2];
            Iterable $this$map$iv = group.getSegments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SourceMapSegment sourceMapSegment = (SourceMapSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it.getGeneratedColumnNumber(), (Object)it));
            }
            Map segmentsByColumn = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            int n2 = generatedLine.length();
            for (int i = 0; i < n2; ++i) {
                if ((SourceMapSegment)segmentsByColumn.get(i) != null) {
                    SourceMapSegment sourceMapSegment;
                    boolean bl3 = false;
                    String sourceFile = sourceMapSegment.component2();
                    int sourceLine = sourceMapSegment.component3();
                    int sourceColumn = sourceMapSegment.component4();
                    String name2 = sourceMapSegment.component5();
                    String nameIfPresent = name2 != null ? '(' + name2 + ')' : "";
                    writer.print('<' + sourceFile + ':' + (sourceLine + 1) + ':' + (sourceColumn + 1) + nameIfPresent + '>');
                }
                writer.print(generatedLine.charAt(i));
            }
            writer.println();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nJ\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap$Companion;", "", "()V", "mapSources", "", "content", "", "output", "Ljava/io/Writer;", "mapping", "Lkotlin/Function1;", "replaceSources", "sourceMapFile", "Ljava/io/File;", "js.parser"})
    @SourceDebugExtension(value={"SMAP\nSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1620#2,3:115\n*S KotlinDebug\n*F\n+ 1 SourceMap.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap$Companion\n*L\n78#1:115,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean replaceSources(@NotNull File sourceMapFile, @NotNull Function1<? super String, String> mapping2) throws IOException, SourceMapSourceReplacementException {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)sourceMapFile, (String)"sourceMapFile");
            Intrinsics.checkNotNullParameter(mapping2, (String)"mapping");
            String content2 = FilesKt.readText$default((File)sourceMapFile, null, (int)1, null);
            Object object = sourceMapFile;
            Charset charset = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
            int n = 8192;
            object = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl2 = false;
                bl = Companion.mapSources(content2, it, mapping2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean mapSources(@NotNull String content2, @NotNull Writer output2, @NotNull Function1<? super String, String> mapping2) throws IOException, SourceMapSourceReplacementException {
            JsonNode jsonNode;
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter(mapping2, (String)"mapping");
            try {
                jsonNode = JSONKt.parseJson(content2);
            }
            catch (JsonSyntaxException e) {
                throw new SourceMapSourceReplacementException(null, (Throwable)e, 1, null);
            }
            JsonNode json = jsonNode;
            JsonObject jsonObject = json instanceof JsonObject ? (JsonObject)json : null;
            if (jsonObject == null) {
                throw new SourceMapSourceReplacementException("Top-level object expected", null, 2, null);
            }
            JsonObject jsonObject2 = jsonObject;
            JsonNode sources = jsonObject2.getProperties().get("sources");
            if (sources != null) {
                void destination$iv;
                void $this$mapTo$iv;
                JsonArray jsonArray = sources instanceof JsonArray ? (JsonArray)sources : null;
                if (jsonArray == null) {
                    throw new SourceMapSourceReplacementException("'sources' property is not of array type", null, 2, null);
                }
                JsonArray sourcesArray = jsonArray;
                boolean changed = false;
                Iterable iterable = sourcesArray.getElements();
                Collection collection = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    JsonString sourcePath;
                    void it;
                    JsonNode jsonNode2 = (JsonNode)item$iv;
                    void var19_19 = destination$iv;
                    boolean bl = false;
                    if ((it instanceof JsonString ? (JsonString)it : null) == null) {
                        throw new SourceMapSourceReplacementException("'sources' array must contain strings", null, 2, null);
                    }
                    sourcePath = sourcePath;
                    String replacedPath = (String)mapping2.invoke((Object)sourcePath.getValue());
                    if (!changed && !Intrinsics.areEqual((Object)replacedPath, (Object)sourcePath.getValue())) {
                        changed = true;
                    }
                    var19_19.add(new JsonString(replacedPath));
                }
                List fixedSources = (List)destination$iv;
                if (!changed) {
                    return false;
                }
                jsonObject2.getProperties().put("sources", new JsonArray(fixedSources));
            }
            jsonObject2.write(output2);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

