/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import javax.annotation.Nullable;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.steps.AbstractCaptureStateBeforeExecutionStep;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class CaptureIncrementalStateBeforeExecutionStep<C extends PreviousExecutionContext, R extends CachingResult>
extends AbstractCaptureStateBeforeExecutionStep<C, R> {
    private final OutputSnapshotter outputSnapshotter;
    private final OverlappingOutputDetector overlappingOutputDetector;

    public CaptureIncrementalStateBeforeExecutionStep(BuildOperationExecutor buildOperationExecutor, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, OutputSnapshotter outputSnapshotter, OverlappingOutputDetector overlappingOutputDetector, Step<? super BeforeExecutionContext, ? extends R> delegate) {
        super(buildOperationExecutor, classLoaderHierarchyHasher, delegate);
        this.outputSnapshotter = outputSnapshotter;
        this.overlappingOutputDetector = overlappingOutputDetector;
    }

    @Override
    protected ImmutableSortedMap<String, FileSystemSnapshot> captureOutputSnapshots(UnitOfWork work, WorkspaceContext context) {
        return this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
    }

    @Override
    @Nullable
    protected OverlappingOutputs detectOverlappingOutputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots) {
        if (work.getOverlappingOutputHandling() == UnitOfWork.OverlappingOutputHandling.IGNORE_OVERLAPS) {
            return null;
        }
        ImmutableSortedMap previousOutputSnapshots = context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        return this.overlappingOutputDetector.detect((ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputSnapshots, unfilteredOutputSnapshots);
    }
}

