/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class VariantResolvingArtifactSet
implements ArtifactSet {
    private final VariantArtifactResolver variantResolver;
    private final ComponentGraphResolveState component;
    private final VariantGraphResolveState variant;
    private final ComponentIdentifier componentId;
    private final AttributesSchemaInternal producerSchema;
    private final ImmutableAttributes overriddenAttributes;
    private final List<IvyArtifactName> artifacts;
    private final ExcludeSpec exclusions;
    private final List<Capability> capabilities;
    private final GraphVariantSelector graphVariantSelector;
    private final AttributesSchemaInternal consumerSchema;
    private final Lazy<ImmutableSet<ResolvedVariant>> ownArtifacts = Lazy.locking().of(this::calculateOwnArtifacts);

    public VariantResolvingArtifactSet(VariantArtifactResolver variantResolver, ComponentGraphResolveState component, VariantGraphResolveState variant, DependencyGraphEdge dependency, GraphVariantSelector graphVariantSelector, AttributesSchemaInternal consumerSchema) {
        this.variantResolver = variantResolver;
        this.component = component;
        this.variant = variant;
        this.componentId = component.getId();
        this.producerSchema = component.getMetadata().getAttributesSchema();
        this.overriddenAttributes = dependency.getAttributes();
        this.artifacts = dependency.getDependencyMetadata().getArtifacts();
        this.exclusions = dependency.getExclusions();
        this.capabilities = dependency.getSelector().getRequested().getRequestedCapabilities();
        this.graphVariantSelector = graphVariantSelector;
        this.consumerSchema = consumerSchema;
    }

    @Override
    public ResolvedArtifactSet select(ArtifactVariantSelector variantSelector, ArtifactSelectionSpec spec) {
        ImmutableSet<ResolvedVariant> variants;
        if (!spec.getComponentFilter().isSatisfiedBy((Object)this.componentId)) {
            return ResolvedArtifactSet.EMPTY;
        }
        if (spec.getSelectFromAllVariants() && !this.artifacts.isEmpty()) {
            return ResolvedArtifactSet.EMPTY;
        }
        try {
            variants = !spec.getSelectFromAllVariants() ? (ImmutableSet<ResolvedVariant>)this.ownArtifacts.get() : this.getArtifactVariantsForReselection(spec.getRequestAttributes());
        }
        catch (Exception e) {
            return new BrokenResolvedArtifactSet(e);
        }
        if (variants.isEmpty() && spec.getAllowNoMatchingVariants()) {
            return ResolvedArtifactSet.EMPTY;
        }
        DefaultResolvedVariantSet variantSet = new DefaultResolvedVariantSet(this.componentId, this.producerSchema, this.overriddenAttributes, variants);
        return variantSelector.select(variantSet, spec.getRequestAttributes(), spec.getAllowNoMatchingVariants(), this::asTransformed);
    }

    private ResolvedArtifactSet asTransformed(ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory, TransformedVariantFactory transformedVariantFactory) {
        if (this.componentId instanceof ProjectComponentIdentifier) {
            return transformedVariantFactory.transformedProjectArtifacts(this.componentId, sourceVariant, variantDefinition, dependenciesResolverFactory);
        }
        return transformedVariantFactory.transformedExternalArtifacts(this.componentId, sourceVariant, variantDefinition, dependenciesResolverFactory);
    }

    public ImmutableSet<ResolvedVariant> calculateOwnArtifacts() {
        if (this.artifacts.isEmpty()) {
            return this.getArtifactsForGraphVariant(this.variant);
        }
        return ImmutableSet.of((Object)this.variant.prepareForArtifactResolution().resolveAdhocVariant(this.variantResolver, this.artifacts));
    }

    private ImmutableSet<ResolvedVariant> getArtifactVariantsForReselection(ImmutableAttributes requestAttributes) {
        GraphVariantSelectionResult selectedGraphVariants = this.graphVariantSelector.selectVariantsLenient(requestAttributes, this.capabilities, this.component, this.consumerSchema, Collections.emptyList());
        if (selectedGraphVariants.getVariants().isEmpty()) {
            return ImmutableSet.of();
        }
        assert (selectedGraphVariants.getVariants().size() == 1);
        VariantGraphResolveState graphVariant = selectedGraphVariants.getVariants().get(0);
        return this.getArtifactsForGraphVariant(graphVariant);
    }

    private ImmutableSet<ResolvedVariant> getArtifactsForGraphVariant(VariantGraphResolveState graphVariant) {
        VariantArtifactResolveState variantState = graphVariant.prepareForArtifactResolution();
        Set<? extends VariantResolveMetadata> artifactVariants = variantState.getArtifactVariants();
        ImmutableSet.Builder resolved = ImmutableSet.builderWithExpectedSize((int)artifactVariants.size());
        ComponentArtifactResolveMetadata componentMetadata = this.component.prepareForArtifactResolution().getResolveMetadata();
        if (this.exclusions.mayExcludeArtifacts()) {
            for (VariantResolveMetadata variantResolveMetadata : artifactVariants) {
                resolved.add((Object)this.variantResolver.resolveVariant(componentMetadata, variantResolveMetadata, this.exclusions));
            }
        } else {
            for (VariantResolveMetadata variantResolveMetadata : artifactVariants) {
                resolved.add((Object)this.variantResolver.resolveVariant(componentMetadata, variantResolveMetadata));
            }
        }
        return resolved.build();
    }
}

