/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.transformers;

import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;

public class ProblemStreamLocationTransformer
implements ProblemTransformer {
    private final ProblemStream problemStream;

    public ProblemStreamLocationTransformer(ProblemStream problemStream) {
        this.problemStream = problemStream;
    }

    public Problem transform(Problem problem, OperationIdentifier id) {
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller((Throwable)problem.getException());
        Location loc = problemDiagnostics.getLocation();
        InternalProblemBuilder builder = problem.toBuilder();
        if (loc != null) {
            builder.lineInFileLocation(loc.getSourceLongDisplayName().getDisplayName(), loc.getLineNumber());
        }
        if (problemDiagnostics.getSource() != null && problemDiagnostics.getSource().getPluginId() != null) {
            builder.pluginLocation(problemDiagnostics.getSource().getPluginId()).build();
        }
        return builder.build();
    }
}

