/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.execution.model.annotations.ModifierAnnotationCategory;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.internal.TextUtil;

public class ServiceReferencePropertyAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    private static final String SERVICE_REFERENCE_MUST_BE_A_BUILD_SERVICE = "SERVICE_REFERENCE_MUST_BE_A_BUILD_SERVICE";

    public ServiceReferencePropertyAnnotationHandler() {
        super(ServiceReference.class, PropertyAnnotationHandler.Kind.OTHER, ModifierAnnotationCategory.annotationsOf(ModifierAnnotationCategory.OPTIONAL));
    }

    public boolean isPropertyRelevant() {
        return true;
    }

    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
        propertyMetadata.getAnnotation(ServiceReference.class).ifPresent(annotation -> {
            String serviceName = annotation.value();
            TypeToken declaredType = propertyMetadata.getDeclaredType();
            Class serviceType = (Class)Cast.uncheckedCast((Object)((ParameterizedType)declaredType.getType()).getActualTypeArguments()[0]);
            visitor.visitServiceReference(propertyName, propertyMetadata.isAnnotationPresent(Optional.class), value, serviceName, (Class)Cast.uncheckedCast((Object)serviceType));
        });
    }

    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        ModelType propertyType = ModelType.of((Type)propertyMetadata.getDeclaredType().getType());
        List typeVariables = (List)Cast.uncheckedNonnullCast((Object)propertyType.getTypeVariables());
        if (typeVariables.size() != 1 || !BuildService.class.isAssignableFrom(((ModelType)typeVariables.get(0)).getRawClass())) {
            validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)SERVICE_REFERENCE_MUST_BE_A_BUILD_SERVICE), "Property has @ServiceReference annotation", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("has @ServiceReference annotation used on property of type '%s' which is not a build service implementation", ((ModelType)typeVariables.get(0)).getName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)SERVICE_REFERENCE_MUST_BE_A_BUILD_SERVICE.toLowerCase())).severity(Severity.ERROR).details(String.format("A property annotated with @ServiceReference must be of a type that implements '%s'", BuildService.class.getName())).solution(String.format("Make '%s' implement '%s'", ((ModelType)typeVariables.get(0)).getName(), BuildService.class.getName())).solution(String.format("Replace the @ServiceReference annotation on '%s' with @Internal and assign a value of type '%s' explicitly", propertyMetadata.getPropertyName(), ((ModelType)typeVariables.get(0)).getName())));
        }
    }
}

