/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.function.Predicate;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;

public class JvmInstallationMetadataMatcher
implements Predicate<JvmInstallationMetadata> {
    private final JavaLanguageVersion languageVersion;
    private final DefaultJvmVendorSpec vendorSpec;
    private final JvmImplementation jvmImplementation;

    public JvmInstallationMetadataMatcher(JavaLanguageVersion languageVersion, JvmVendorSpec vendorSpec, JvmImplementation jvmImplementation) {
        this.languageVersion = languageVersion;
        this.vendorSpec = (DefaultJvmVendorSpec)vendorSpec;
        this.jvmImplementation = jvmImplementation;
    }

    public JvmInstallationMetadataMatcher(JavaToolchainSpec spec) {
        this((JavaLanguageVersion)spec.getLanguageVersion().get(), (JvmVendorSpec)spec.getVendor().get(), (JvmImplementation)spec.getImplementation().get());
    }

    @Override
    public boolean test(JvmInstallationMetadata metadata) {
        Predicate<? super JvmInstallationMetadata> predicate = this.languagePredicate().and(this.vendorPredicate()).and(this.implementationPredicate());
        return predicate.test((JvmInstallationMetadata)metadata);
    }

    private Predicate<JvmInstallationMetadata> languagePredicate() {
        return metadata -> {
            JavaLanguageVersion actualVersion = JavaToolchain.getJavaLanguageVersion(metadata);
            return actualVersion.equals(this.languageVersion);
        };
    }

    private Predicate<? super JvmInstallationMetadata> implementationPredicate() {
        return metadata -> {
            if (this.jvmImplementation == JvmImplementation.VENDOR_SPECIFIC) {
                return true;
            }
            boolean j9Requested = this.isJ9ExplicitlyRequested() || this.isJ9RequestedViaVendor();
            boolean isJ9Vm = metadata.hasCapability(JvmInstallationMetadata.JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            return j9Requested == isJ9Vm;
        };
    }

    private boolean isJ9ExplicitlyRequested() {
        return this.jvmImplementation == JvmImplementation.J9;
    }

    private boolean isJ9RequestedViaVendor() {
        return this.vendorSpec != DefaultJvmVendorSpec.any() && this.vendorSpec.test(JvmVendor.KnownJvmVendor.IBM.asJvmVendor());
    }

    private Predicate<JvmInstallationMetadata> vendorPredicate() {
        return this.vendorSpec;
    }
}

