/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.InputStream;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.launcher.daemon.client.DaemonClientInputForwarder;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.InputMessage;
import org.gradle.launcher.daemon.protocol.UserResponse;
import org.gradle.launcher.daemon.server.clientinput.ClientInputForwarder;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class ForwardStdInToThisProcess
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final GlobalUserInputReceiver userInputReceiver;
    private final UserInputReader userInputReader;
    private final InputStream finalStandardInput;
    private final BuildActionExecuter<BuildActionParameters, BuildRequestContext> delegate;
    private final ExecutorFactory executorFactory;

    public ForwardStdInToThisProcess(GlobalUserInputReceiver userInputReceiver, UserInputReader userInputReader, InputStream finalStandardInput, BuildActionExecuter<BuildActionParameters, BuildRequestContext> delegate, ExecutorFactory executorFactory) {
        this.userInputReceiver = userInputReceiver;
        this.userInputReader = userInputReader;
        this.finalStandardInput = finalStandardInput;
        this.delegate = delegate;
        this.executorFactory = executorFactory;
    }

    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext buildRequestContext) {
        ClientInputForwarder forwarder = new ClientInputForwarder(this.userInputReader);
        return forwarder.forwardInput(stdinHandler -> {
            DaemonClientInputForwarder inputForwarder = new DaemonClientInputForwarder(this.finalStandardInput, (Dispatch<? super InputMessage>)((Dispatch)message -> {
                if (message instanceof UserResponse) {
                    stdinHandler.onUserResponse((UserResponse)message);
                } else if (message instanceof ForwardInput) {
                    stdinHandler.onInput((ForwardInput)message);
                } else if (message instanceof CloseInput) {
                    stdinHandler.onEndOfInput();
                } else {
                    throw new IllegalArgumentException();
                }
            }), this.userInputReceiver, this.executorFactory);
            inputForwarder.start();
            try {
                BuildActionResult buildActionResult = this.delegate.execute(action, actionParameters, buildRequestContext);
                return buildActionResult;
            }
            finally {
                inputForwarder.stop();
                stdinHandler.onEndOfInput();
            }
        });
    }
}

