/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.declarativedsl.analysis.AnalysisContextView;
import org.gradle.internal.declarativedsl.analysis.AnalysisSchema;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.DataAddition;
import org.gradle.internal.declarativedsl.analysis.DataTypeRef;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.FqName;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.PropertyReferenceResolution;
import org.gradle.internal.declarativedsl.analysis.SchemaTypeRefContext;
import org.gradle.internal.declarativedsl.language.DataType;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020)J\u0016\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J&\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContextView;", "schema", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisSchema;", "imports", "", "", "Lorg/gradle/internal/declarativedsl/analysis/FqName;", "errorCollector", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "(Lorg/gradle/internal/declarativedsl/analysis/AnalysisSchema;Ljava/util/Map;Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;)V", "additions", "", "Lorg/gradle/internal/declarativedsl/analysis/DataAddition;", "getAdditions", "()Ljava/util/List;", "assignments", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "getAssignments", "currentScopes", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisScope;", "getCurrentScopes", "getErrorCollector", "()Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "getImports", "()Ljava/util/Map;", "mutableAdditions", "", "mutableAssignments", "mutableScopes", "nextInstant", "Ljava/util/concurrent/atomic/AtomicLong;", "getSchema", "()Lorg/gradle/internal/declarativedsl/analysis/AnalysisSchema;", "typeRefContext", "Lorg/gradle/internal/declarativedsl/analysis/SchemaTypeRefContext;", "enterScope", "", "newScope", "leaveScope", "scope", "", "recordAddition", "container", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "dataObject", "recordAssignment", "resolvedTarget", "Lorg/gradle/internal/declarativedsl/analysis/PropertyReferenceResolution;", "resolvedRhs", "assignmentMethod", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentMethod;", "originElement", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "resolveRef", "Lorg/gradle/internal/declarativedsl/language/DataType;", "dataTypeRef", "Lorg/gradle/internal/declarativedsl/analysis/DataTypeRef;", "declarative-dsl-core"})
public final class AnalysisContext
implements AnalysisContextView {
    @NotNull
    private final AnalysisSchema schema;
    @NotNull
    private final Map<String, FqName> imports;
    @NotNull
    private final ErrorCollector errorCollector;
    @NotNull
    private final List<AnalysisScope> mutableScopes;
    @NotNull
    private final List<AssignmentRecord> mutableAssignments;
    @NotNull
    private final AtomicLong nextInstant;
    @NotNull
    private final List<DataAddition> mutableAdditions;
    @NotNull
    private final SchemaTypeRefContext typeRefContext;

    public AnalysisContext(@NotNull AnalysisSchema schema, @NotNull Map<String, FqName> imports, @NotNull ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(imports, (String)"imports");
        Intrinsics.checkNotNullParameter((Object)errorCollector, (String)"errorCollector");
        this.schema = schema;
        this.imports = imports;
        this.errorCollector = errorCollector;
        this.mutableScopes = new ArrayList();
        this.mutableAssignments = new ArrayList();
        this.nextInstant = new AtomicLong(1L);
        this.mutableAdditions = new ArrayList();
        this.typeRefContext = new SchemaTypeRefContext(this.getSchema());
    }

    @Override
    @NotNull
    public AnalysisSchema getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public Map<String, FqName> getImports() {
        return this.imports;
    }

    @NotNull
    public final ErrorCollector getErrorCollector() {
        return this.errorCollector;
    }

    @NotNull
    public List<AnalysisScope> getCurrentScopes() {
        return this.mutableScopes;
    }

    @Override
    @NotNull
    public List<AssignmentRecord> getAssignments() {
        return this.mutableAssignments;
    }

    @NotNull
    public final List<DataAddition> getAdditions() {
        return this.mutableAdditions;
    }

    @Override
    @NotNull
    public DataType resolveRef(@NotNull DataTypeRef dataTypeRef) {
        Intrinsics.checkNotNullParameter((Object)dataTypeRef, (String)"dataTypeRef");
        return this.typeRefContext.resolveRef(dataTypeRef);
    }

    public final void enterScope(@NotNull AnalysisScope newScope) {
        Intrinsics.checkNotNullParameter((Object)newScope, (String)"newScope");
        this.mutableScopes.add(newScope);
    }

    @NotNull
    public final AssignmentRecord recordAssignment(@NotNull PropertyReferenceResolution resolvedTarget, @NotNull ObjectOrigin resolvedRhs, @NotNull AssignmentMethod assignmentMethod, @NotNull LanguageTreeElement originElement) {
        Intrinsics.checkNotNullParameter((Object)resolvedTarget, (String)"resolvedTarget");
        Intrinsics.checkNotNullParameter((Object)resolvedRhs, (String)"resolvedRhs");
        Intrinsics.checkNotNullParameter((Object)assignmentMethod, (String)"assignmentMethod");
        Intrinsics.checkNotNullParameter((Object)originElement, (String)"originElement");
        AssignmentRecord result = new AssignmentRecord(resolvedTarget, resolvedRhs, this.nextInstant(), assignmentMethod, originElement);
        this.mutableAssignments.add(result);
        return result;
    }

    public final void recordAddition(@NotNull ObjectOrigin container, @NotNull ObjectOrigin dataObject) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        ((Collection)this.mutableAdditions).add(new DataAddition(container, dataObject));
    }

    public final long nextInstant() {
        return this.nextInstant.incrementAndGet();
    }

    public final void leaveScope(@NotNull AnalysisScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!(CollectionsKt.last(this.mutableScopes) == scope)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        CollectionsKt.removeLast(this.mutableScopes);
    }
}

