/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.configurationcache.ClassLoaderScopeSpec;
import org.gradle.configurationcache.serialization.ClassLoaderRole;
import org.gradle.configurationcache.serialization.ScopeLookup;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.initialization.ClassLoaderScopeRegistryListenerManager;
import org.gradle.internal.buildtree.BuildTreeLifecycleListener;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J2\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J\u0006\u0010#\u001a\u00020\u0013J \u0010$\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gradle/configurationcache/ConfigurationCacheClassLoaderScopeRegistryListener;", "Lorg/gradle/initialization/ClassLoaderScopeRegistryListener;", "Lorg/gradle/configurationcache/serialization/ScopeLookup;", "Lorg/gradle/internal/buildtree/BuildTreeLifecycleListener;", "Ljava/io/Closeable;", "listenerManager", "Lorg/gradle/initialization/ClassLoaderScopeRegistryListenerManager;", "(Lorg/gradle/initialization/ClassLoaderScopeRegistryListenerManager;)V", "loaders", "", "Ljava/lang/ClassLoader;", "Lkotlin/Pair;", "Lorg/gradle/configurationcache/ClassLoaderScopeSpec;", "Lorg/gradle/configurationcache/serialization/ClassLoaderRole;", "lock", "", "scopeSpecs", "Lorg/gradle/initialization/ClassLoaderScopeId;", "afterStart", "", "childScopeCreated", "parentId", "childId", "origin", "Lorg/gradle/initialization/ClassLoaderScopeOrigin;", "classloaderCreated", "scopeId", "classLoaderId", "Lorg/gradle/api/internal/initialization/loadercache/ClassLoaderId;", "classLoader", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "implementationHash", "Lorg/gradle/internal/hash/HashCode;", "close", "dispose", "scopeFor", "configuration-cache"})
public final class ConfigurationCacheClassLoaderScopeRegistryListener
implements ClassLoaderScopeRegistryListener,
ScopeLookup,
BuildTreeLifecycleListener,
Closeable {
    @NotNull
    private final ClassLoaderScopeRegistryListenerManager listenerManager;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<ClassLoaderScopeId, ClassLoaderScopeSpec> scopeSpecs;
    @NotNull
    private final Map<ClassLoader, Pair<ClassLoaderScopeSpec, ClassLoaderRole>> loaders;

    public ConfigurationCacheClassLoaderScopeRegistryListener(@NotNull ClassLoaderScopeRegistryListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.listenerManager = listenerManager;
        this.lock = new Object();
        this.scopeSpecs = new LinkedHashMap();
        this.loaders = new LinkedHashMap();
    }

    public void afterStart() {
        this.listenerManager.add((ClassLoaderScopeRegistryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.scopeSpecs.clear();
            this.loaders.clear();
            this.listenerManager.remove((ClassLoaderScopeRegistryListener)this);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Pair<ClassLoaderScopeSpec, ClassLoaderRole> scopeFor(@Nullable ClassLoader classLoader) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Pair<ClassLoaderScopeSpec, ClassLoaderRole> pair = this.loaders.get(classLoader);
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childScopeCreated(@NotNull ClassLoaderScopeId parentId, @NotNull ClassLoaderScopeId childId, @Nullable ClassLoaderScopeOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)childId, (String)"childId");
        Object object = this.lock;
        synchronized (object) {
            ClassLoaderScopeSpec classLoaderScopeSpec;
            boolean parentIsRoot;
            boolean bl = false;
            if (this.scopeSpecs.containsKey(childId)) {
                return;
            }
            boolean bl2 = parentIsRoot = parentId.getParent() == null;
            if (parentIsRoot) {
                classLoaderScopeSpec = null;
            } else {
                ClassLoaderScopeSpec lookupParent = this.scopeSpecs.get(parentId);
                if (!(lookupParent != null)) {
                    boolean bl3 = false;
                    String string2 = "Cannot find parent " + parentId + " for child scope " + childId;
                    throw new IllegalArgumentException(string2.toString());
                }
                classLoaderScopeSpec = lookupParent;
            }
            ClassLoaderScopeSpec parent = classLoaderScopeSpec;
            String string3 = childId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"childId.name");
            ClassLoaderScopeSpec child = new ClassLoaderScopeSpec(parent, string3, origin);
            this.scopeSpecs.put(childId, child);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classloaderCreated(@NotNull ClassLoaderScopeId scopeId, @NotNull ClassLoaderId classLoaderId, @NotNull ClassLoader classLoader, @NotNull ClassPath classPath, @Nullable HashCode implementationHash) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)classLoaderId, (String)"classLoaderId");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Object object = this.lock;
        synchronized (object) {
            boolean local;
            boolean bl = false;
            ClassLoaderScopeSpec spec = this.scopeSpecs.get(scopeId);
            if (!(spec != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            boolean bl2 = local = scopeId instanceof ClassLoaderScopeIdentifier && Intrinsics.areEqual((Object)((ClassLoaderScopeIdentifier)scopeId).localId(), (Object)classLoaderId);
            if (local) {
                spec.setLocalClassPath(classPath);
                spec.setLocalImplementationHash(implementationHash);
            } else {
                spec.setExportClassPath(classPath);
            }
            this.loaders.put(classLoader, (Pair<ClassLoaderScopeSpec, ClassLoaderRole>)new Pair((Object)spec, (Object)ClassLoaderRole.box-impl(ClassLoaderRole.constructor-impl(local))));
            Unit unit = Unit.INSTANCE;
        }
    }
}

