/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.AttributesToMapConverter;
import org.gradle.api.internal.artifacts.transform.ComponentToOperationConverter;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.DefaultPlannedTransformStepIdentity;
import org.gradle.api.internal.artifacts.transform.DefaultTransformNodeDependency;
import org.gradle.api.internal.artifacts.transform.ExecutePlannedTransformStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.execution.plan.CreationOrderedNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.Describables;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationMetadata;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.operations.dependencies.transforms.ExecutePlannedTransformStepBuildOperationType;
import org.gradle.operations.dependencies.transforms.PlannedTransformStepIdentity;
import org.gradle.operations.dependencies.variants.Capability;
import org.gradle.operations.dependencies.variants.ComponentIdentifier;

public abstract class TransformStepNode
extends CreationOrderedNode
implements SelfExecutingNode {
    protected final TransformStep transformStep;
    protected final ResolvableArtifact artifact;
    private final ComponentVariantIdentifier targetComponentVariant;
    private final AttributeContainer sourceAttributes;
    protected final TransformUpstreamDependencies upstreamDependencies;
    private final long transformStepNodeId;
    private PlannedTransformStepIdentity cachedIdentity;
    private static final ExecutePlannedTransformStepBuildOperationType.Result RESULT = new ExecutePlannedTransformStepBuildOperationType.Result(){};

    protected TransformStepNode(long transformStepNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep transformStep, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies) {
        this.targetComponentVariant = targetComponentVariant;
        this.sourceAttributes = sourceAttributes;
        this.transformStep = transformStep;
        this.artifact = artifact;
        this.upstreamDependencies = upstreamDependencies;
        this.transformStepNodeId = transformStepNodeId;
    }

    public long getTransformStepNodeId() {
        return this.transformStepNodeId;
    }

    public ComponentVariantIdentifier getTargetComponentVariant() {
        return this.targetComponentVariant;
    }

    public AttributeContainer getSourceAttributes() {
        return this.sourceAttributes;
    }

    public PlannedTransformStepIdentity getNodeIdentity() {
        if (this.cachedIdentity == null) {
            this.cachedIdentity = this.createIdentity();
        }
        return this.cachedIdentity;
    }

    private PlannedTransformStepIdentity createIdentity() {
        String consumerBuildPath = this.transformStep.getOwningProject().getBuildPath().toString();
        String consumerProjectPath = this.transformStep.getOwningProject().getProjectPath().toString();
        ComponentIdentifier componentId = ComponentToOperationConverter.convertComponentIdentifier(this.targetComponentVariant.getComponentId());
        Map<String, String> sourceAttributes = AttributesToMapConverter.convertToMap(this.sourceAttributes);
        Map<String, String> targetAttributes = AttributesToMapConverter.convertToMap(this.targetComponentVariant.getAttributes());
        List<Capability> capabilities = this.targetComponentVariant.getCapabilities().asSet().stream().map(TransformStepNode::convertCapability).collect(Collectors.toList());
        return new DefaultPlannedTransformStepIdentity(consumerBuildPath, consumerProjectPath, componentId, sourceAttributes, targetAttributes, capabilities, this.artifact.getArtifactName().getDisplayName(), this.upstreamDependencies.getConfigurationIdentity(), this.transformStepNodeId);
    }

    private static Capability convertCapability(final org.gradle.api.capabilities.Capability capability) {
        return new Capability(){

            public String getGroup() {
                return capability.getGroup();
            }

            public String getName() {
                return capability.getName();
            }

            public String getVersion() {
                return capability.getVersion();
            }

            public String toString() {
                return this.getGroup() + ":" + this.getName() + (this.getVersion() == null ? "" : ":" + this.getVersion());
            }
        };
    }

    public ResolvableArtifact getInputArtifact() {
        return this.artifact;
    }

    public TransformUpstreamDependencies getUpstreamDependencies() {
        return this.upstreamDependencies;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return this.transformStep.getOwningProject();
    }

    public boolean isPublicNode() {
        return true;
    }

    public String toString() {
        return this.transformStep.getDisplayName();
    }

    public TransformStep getTransformStep() {
        return this.transformStep;
    }

    public Try<TransformStepSubject> getTransformedSubject() {
        return this.getTransformedArtifacts().getValue();
    }

    public void execute(NodeExecutionContext context) {
        this.getTransformedArtifacts().run(context);
    }

    public void executeIfNotAlready() {
        this.transformStep.isolateParametersIfNotAlready();
        this.upstreamDependencies.finalizeIfNotAlready();
        this.getTransformedArtifacts().finalizeIfNotAlready();
    }

    protected abstract CalculatedValueContainer<TransformStepSubject, ?> getTransformedArtifacts();

    public Throwable getNodeFailure() {
        return null;
    }

    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        this.processDependencies(dependencyResolver.resolveDependenciesFor(null, context -> this.getTransformedArtifacts().visitDependencies(context)));
    }

    protected void processDependencies(Set<Node> dependencies) {
        for (Node dependency : dependencies) {
            this.addDependencySuccessor(dependency);
        }
    }

    protected abstract class TransformStepBuildOperation
    implements CallableBuildOperation<TransformStepSubject> {
        private static final String TRANSFORMING_PROGRESS_PREFIX = "Transforming ";

        protected TransformStepBuildOperation() {
        }

        public final BuildOperationDescriptor.Builder description() {
            String transformStepName = TransformStepNode.this.transformStep.getDisplayName();
            String subjectName = this.describeSubject();
            String basicName = subjectName + " with " + transformStepName;
            return BuildOperationDescriptor.displayName((String)("Transform " + basicName)).progressDisplayName(TRANSFORMING_PROGRESS_PREFIX + basicName).metadata((BuildOperationMetadata)BuildOperationCategory.TRANSFORM).details((Object)new ExecutePlannedTransformStepBuildOperationDetails(TransformStepNode.this, transformStepName, subjectName));
        }

        protected abstract String describeSubject();

        public TransformStepSubject call(BuildOperationContext context) {
            context.setResult((Object)RESULT);
            return this.transform();
        }

        protected abstract TransformStepSubject transform();
    }

    protected abstract class AbstractTransformArtifacts
    implements ValueCalculator<TransformStepSubject> {
        private final BuildOperationRunner buildOperationRunner;

        protected AbstractTransformArtifacts(BuildOperationRunner buildOperationRunner) {
            this.buildOperationRunner = buildOperationRunner;
        }

        @OverridingMethodsMustInvokeSuper
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)TransformStepNode.this.transformStep);
            context.add((Object)TransformStepNode.this.upstreamDependencies);
        }

        public TransformStepSubject calculateValue(NodeExecutionContext context) {
            TransformStepBuildOperation buildOperation = this.createBuildOperation(context);
            ProjectInternal owningProject = TransformStepNode.this.transformStep.getOwningProject();
            return owningProject == null ? buildOperation.transform() : (TransformStepSubject)this.buildOperationRunner.call((CallableBuildOperation)buildOperation);
        }

        protected abstract TransformStepBuildOperation createBuildOperation(NodeExecutionContext var1);
    }

    public static class ChainedTransformStepNode
    extends TransformStepNode {
        private final TransformStepNode previousTransformStepNode;
        private final CalculatedValueContainer<TransformStepSubject, TransformPreviousArtifacts> result;

        public ChainedTransformStepNode(long transformStepNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep transformStep, TransformStepNode previousTransformStepNode, TransformUpstreamDependencies upstreamDependencies, BuildOperationRunner buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(transformStepNodeId, targetComponentVariant, sourceAttributes, transformStep, previousTransformStepNode.artifact, upstreamDependencies);
            this.previousTransformStepNode = previousTransformStepNode;
            this.result = calculatedValueContainerFactory.create(Describables.of((Object)((Object)this)), (ValueCalculator)new TransformPreviousArtifacts(buildOperationExecutor));
        }

        public TransformStepNode getPreviousTransformStepNode() {
            return this.previousTransformStepNode;
        }

        protected CalculatedValueContainer<TransformStepSubject, TransformPreviousArtifacts> getTransformedArtifacts() {
            return this.result;
        }

        @Override
        public void executeIfNotAlready() {
            this.previousTransformStepNode.executeIfNotAlready();
            super.executeIfNotAlready();
        }

        protected class TransformPreviousArtifacts
        extends AbstractTransformArtifacts {
            public TransformPreviousArtifacts(BuildOperationRunner buildOperationRunner) {
                super(buildOperationRunner);
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                super.visitDependencies(context);
                context.add((Object)new DefaultTransformNodeDependency(Collections.singletonList(ChainedTransformStepNode.this.previousTransformStepNode)));
            }

            @Override
            protected TransformStepBuildOperation createBuildOperation(final NodeExecutionContext context) {
                return new TransformStepBuildOperation(){

                    @Override
                    protected TransformStepSubject transform() {
                        return (TransformStepSubject)ChainedTransformStepNode.this.previousTransformStepNode.getTransformedSubject().flatMap(transformedSubject -> (Try)ChainedTransformStepNode.this.transformStep.createInvocation((TransformStepSubject)transformedSubject, ChainedTransformStepNode.this.upstreamDependencies, context).completeAndGet()).get();
                    }

                    @Override
                    protected String describeSubject() {
                        return (String)ChainedTransformStepNode.this.previousTransformStepNode.getTransformedSubject().map(Describable::getDisplayName).getOrMapFailure(Throwable::getMessage);
                    }
                };
            }
        }
    }

    public static class InitialTransformStepNode
    extends TransformStepNode {
        private final CalculatedValueContainer<TransformStepSubject, TransformInitialArtifact> result;

        public InitialTransformStepNode(long transformStepNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep transformStep, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationRunner buildOperationRunner, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(transformStepNodeId, targetComponentVariant, sourceAttributes, transformStep, artifact, upstreamDependencies);
            this.result = calculatedValueContainerFactory.create(Describables.of((Object)((Object)this)), (ValueCalculator)new TransformInitialArtifact(buildOperationRunner));
        }

        protected CalculatedValueContainer<TransformStepSubject, TransformInitialArtifact> getTransformedArtifacts() {
            return this.result;
        }

        protected class TransformInitialArtifact
        extends AbstractTransformArtifacts {
            public TransformInitialArtifact(BuildOperationRunner buildOperationRunner) {
                super(buildOperationRunner);
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                super.visitDependencies(context);
                context.add((Object)InitialTransformStepNode.this.artifact);
            }

            @Override
            protected TransformStepBuildOperation createBuildOperation(final NodeExecutionContext context) {
                return new TransformStepBuildOperation(){

                    @Override
                    protected TransformStepSubject transform() {
                        TransformStepSubject initialSubject;
                        try {
                            initialSubject = TransformStepSubject.initial(InitialTransformStepNode.this.artifact);
                        }
                        catch (ResolveException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            throw new DefaultLenientConfiguration.ArtifactResolveException("artifacts", InitialTransformStepNode.this.transformStep.getDisplayName(), Collections.singleton(e));
                        }
                        return (TransformStepSubject)((Try)InitialTransformStepNode.this.transformStep.createInvocation(initialSubject, InitialTransformStepNode.this.upstreamDependencies, context).completeAndGet()).get();
                    }

                    @Override
                    protected String describeSubject() {
                        return InitialTransformStepNode.this.artifact.getId().getDisplayName();
                    }
                };
            }
        }
    }
}

