/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.artifacts.configurations;

import java.util.Collections;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationCreationRequest;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.internal.artifacts.configurations.AbstractRoleBasedConfigurationCreationRequest;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public final class NoContextRoleBasedConfigurationCreationRequest
extends AbstractRoleBasedConfigurationCreationRequest {
    public NoContextRoleBasedConfigurationCreationRequest(String configurationName, ConfigurationRole role) {
        super(configurationName, role);
    }

    private String getUsageDiscoveryMessage(DeprecatableConfiguration conf) {
        String currentUsageDesc = UsageDescriber.describeCurrentUsage((DeprecatableConfiguration)conf);
        return String.format("Configuration %s already exists with permitted usage(s):\n%s\n", this.getConfigurationName(), currentUsageDesc);
    }

    private String getUsageExpectationMessage() {
        String expectedUsageDesc = UsageDescriber.describeRole((ConfigurationRole)this.getRole());
        return String.format("Yet Gradle expected to create it with the usage(s):\n%s\nGradle will mutate the usage of configuration %s to match the expected usage. This may cause unexpected behavior. Creating configurations with reserved names", expectedUsageDesc, this.getConfigurationName());
    }

    public void warnAboutNeedToMutateUsage(DeprecatableConfiguration conf) {
        String msgDiscovery = this.getUsageDiscoveryMessage(conf);
        String msgExpectation = this.getUsageExpectationMessage();
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)(msgDiscovery + msgExpectation)).withAdvice(RoleBasedConfigurationCreationRequest.getDefaultReservedNameAdvice((String)this.configurationName)).willBecomeAnErrorInGradle9().withUserManual("authoring_maintainable_build_scripts", "sec:dont_anticipate_configuration_creation")).nagUser();
    }

    public void failOnInabilityToMutateUsage() {
        throw new RoleBasedConfigurationCreationRequest.UnmodifiableUsageException(this.getConfigurationName(), Collections.singletonList(RoleBasedConfigurationCreationRequest.getDefaultReservedNameAdvice((String)this.getConfigurationName())));
    }
}

