/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.ExternalModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;

public class MavenDependencyMetadata
extends ExternalModuleDependencyMetadata {
    private final MavenDependencyDescriptor dependencyDescriptor;

    public MavenDependencyMetadata(MavenDependencyDescriptor dependencyDescriptor) {
        this(dependencyDescriptor, null, false);
    }

    public MavenDependencyMetadata(MavenDependencyDescriptor dependencyDescriptor, @Nullable String reason, boolean endorsing) {
        this(dependencyDescriptor, reason, endorsing, (List<IvyArtifactName>)dependencyDescriptor.getConfigurationArtifacts());
    }

    private MavenDependencyMetadata(MavenDependencyDescriptor dependencyDescriptor, @Nullable String reason, boolean endorsing, List<IvyArtifactName> artifacts) {
        super(reason, endorsing, artifacts);
        this.dependencyDescriptor = dependencyDescriptor;
    }

    @Override
    public MavenDependencyDescriptor getDependencyDescriptor() {
        return this.dependencyDescriptor;
    }

    @Override
    protected GraphVariantSelectionResult selectLegacyConfigurations(GraphVariantSelector variantSelector, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema) {
        VariantGraphResolveState selected = variantSelector.selectLegacyConfiguration(consumerAttributes, targetComponentState, consumerSchema);
        return new GraphVariantSelectionResult(Collections.singletonList(selected), false);
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.getDependencyDescriptor().getConfigurationExcludes();
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        return new MavenDependencyMetadata(this.dependencyDescriptor, reason, this.isEndorsingStrictVersions(), this.getArtifacts());
    }

    @Override
    public ModuleDependencyMetadata withEndorseStrictVersions(boolean endorse) {
        return new MavenDependencyMetadata(this.dependencyDescriptor, this.getReason(), endorse, this.getArtifacts());
    }

    @Override
    protected ModuleDependencyMetadata withRequested(ModuleComponentSelector newSelector) {
        MavenDependencyDescriptor newDescriptor = this.dependencyDescriptor.withRequested(newSelector);
        return new MavenDependencyMetadata(newDescriptor, this.getReason(), this.isEndorsingStrictVersions(), this.getArtifacts());
    }

    @Override
    protected ModuleDependencyMetadata withRequestedAndArtifacts(ModuleComponentSelector newSelector, List<IvyArtifactName> artifacts) {
        MavenDependencyDescriptor newDelegate = this.dependencyDescriptor.withRequested(newSelector);
        return new MavenDependencyMetadata(newDelegate, this.getReason(), this.isEndorsingStrictVersions(), artifacts);
    }
}

