/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.state.ModelObject;

public abstract class ValueState<S> {
    private static final ValueState<Object> FINALIZED_VALUE = new FinalizedValue<Object>();

    public static <S> ValueState<S> newState(PropertyHost host) {
        return new NonFinalizedValue(host, Function.identity());
    }

    public static <S> ValueState<S> newState(PropertyHost host, Function<S, S> copier) {
        return new NonFinalizedValue<S>(host, copier);
    }

    public abstract boolean shouldFinalize(Describable var1, @Nullable ModelObject var2);

    public abstract ValueState<S> finalState();

    public abstract void setConvention(S var1);

    public abstract void disallowChanges();

    public abstract void finalizeOnNextGet();

    public abstract void disallowUnsafeRead();

    public abstract S explicitValue(S var1);

    public abstract S explicitValue(S var1, S var2);

    public abstract S applyConvention(S var1, S var2);

    public abstract S implicitValue();

    public abstract boolean maybeFinalizeOnRead(Describable var1, @Nullable ModelObject var2, ValueSupplier.ValueConsumer var3);

    public abstract void beforeMutate(Describable var1);

    public abstract ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer var1);

    public boolean isFinalized() {
        return this == FINALIZED_VALUE;
    }

    public abstract boolean isFinalizing();

    public void finalizeOnReadIfNeeded(Describable displayName, @Nullable ModelObject effectiveProducer, ValueSupplier.ValueConsumer consumer, Action<ValueSupplier.ValueConsumer> finalizeNow) {
        if (this.maybeFinalizeOnRead(displayName, effectiveProducer, consumer)) {
            finalizeNow.execute((Object)this.forUpstream(consumer));
        }
    }

    public void disallowChangesAndFinalizeOnNextGet() {
        this.disallowChanges();
        this.finalizeOnNextGet();
    }

    public abstract boolean isExplicit();

    public abstract S convention();

    public abstract S setToConvention();

    public abstract S setToConventionIfUnset(S var1);

    private static class FinalizedValue<S>
    extends ValueState<S> {
        private FinalizedValue() {
        }

        @Override
        public boolean shouldFinalize(Describable displayName, @Nullable ModelObject producer) {
            return false;
        }

        @Override
        public void disallowChanges() {
        }

        @Override
        public void finalizeOnNextGet() {
        }

        @Override
        public void disallowUnsafeRead() {
        }

        @Override
        public boolean maybeFinalizeOnRead(Describable displayName, @Nullable ModelObject producer, ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public void beforeMutate(Describable displayName) {
            throw new IllegalStateException(String.format("The value for %s is final and cannot be changed any further.", displayName.getDisplayName()));
        }

        @Override
        public ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer consumer) {
            throw this.unexpected();
        }

        @Override
        public S explicitValue(S value) {
            throw this.unexpected();
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            throw this.unexpected();
        }

        @Override
        public S applyConvention(S value, S convention) {
            throw this.unexpected();
        }

        @Override
        public S implicitValue() {
            throw this.unexpected();
        }

        @Override
        public boolean isFinalizing() {
            return true;
        }

        @Override
        public boolean isExplicit() {
            return true;
        }

        @Override
        public S convention() {
            return null;
        }

        @Override
        public S setToConvention() {
            throw this.unexpected();
        }

        @Override
        public S setToConventionIfUnset(S value) {
            throw this.unexpected();
        }

        @Override
        public ValueState<S> finalState() {
            return this;
        }

        @Override
        public void setConvention(S convention) {
            throw this.unexpected();
        }

        private UnsupportedOperationException unexpected() {
            return new UnsupportedOperationException("Valued object is in an unexpected state.");
        }
    }

    private static class NonFinalizedValue<S>
    extends ValueState<S> {
        private final PropertyHost host;
        private final Function<S, S> copier;
        private boolean explicitValue;
        private boolean finalizeOnNextGet;
        private boolean disallowChanges;
        private boolean disallowUnsafeRead;
        private S convention;

        public NonFinalizedValue(PropertyHost host, Function<S, S> copier) {
            this.host = host;
            this.copier = copier;
        }

        @Override
        public boolean shouldFinalize(Describable displayName, @Nullable ModelObject producer) {
            String reason;
            if (this.disallowUnsafeRead && (reason = this.host.beforeRead(producer)) != null) {
                throw new IllegalStateException(this.cannotFinalizeValueOf(displayName, reason));
            }
            return true;
        }

        @Override
        public ValueState<S> finalState() {
            return (ValueState)Cast.uncheckedCast((Object)FINALIZED_VALUE);
        }

        @Override
        public boolean maybeFinalizeOnRead(Describable displayName, @Nullable ModelObject producer, ValueSupplier.ValueConsumer consumer) {
            String reason;
            if ((this.disallowUnsafeRead || consumer == ValueSupplier.ValueConsumer.DisallowUnsafeRead) && (reason = this.host.beforeRead(producer)) != null) {
                throw new IllegalStateException(this.cannotQueryValueOf(displayName, reason));
            }
            return this.finalizeOnNextGet || consumer == ValueSupplier.ValueConsumer.DisallowUnsafeRead;
        }

        @Override
        public ValueSupplier.ValueConsumer forUpstream(ValueSupplier.ValueConsumer consumer) {
            if (this.disallowUnsafeRead) {
                return ValueSupplier.ValueConsumer.DisallowUnsafeRead;
            }
            return consumer;
        }

        @Override
        public void beforeMutate(Describable displayName) {
            if (this.disallowChanges) {
                throw new IllegalStateException(String.format("The value for %s cannot be changed any further.", displayName.getDisplayName()));
            }
        }

        @Override
        public void disallowChanges() {
            this.disallowChanges = true;
        }

        @Override
        public void finalizeOnNextGet() {
            this.finalizeOnNextGet = true;
        }

        @Override
        public void disallowUnsafeRead() {
            this.disallowUnsafeRead = true;
            this.finalizeOnNextGet = true;
        }

        @Override
        public boolean isFinalizing() {
            return this.finalizeOnNextGet;
        }

        @Override
        public boolean isExplicit() {
            return this.explicitValue;
        }

        @Override
        public S convention() {
            return this.convention;
        }

        @Override
        public S setToConvention() {
            this.explicitValue = true;
            return this.shallowCopy(this.convention);
        }

        private S shallowCopy(S toCopy) {
            return this.copier.apply(toCopy);
        }

        @Override
        public S setToConventionIfUnset(S value) {
            if (!this.explicitValue) {
                return this.setToConvention();
            }
            return value;
        }

        @Override
        public S explicitValue(S value) {
            this.explicitValue = true;
            return value;
        }

        @Override
        public S explicitValue(S value, S defaultValue) {
            if (!this.explicitValue) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public S implicitValue() {
            this.explicitValue = false;
            return this.shallowCopy(this.convention);
        }

        @Override
        public S applyConvention(S value, S convention) {
            this.convention = convention;
            if (!this.explicitValue) {
                return this.shallowCopy(convention);
            }
            return value;
        }

        @Override
        public void setConvention(S convention) {
            this.convention = convention;
        }

        private String cannotFinalizeValueOf(Describable displayName, String reason) {
            return this.cannot("finalize", displayName, reason);
        }

        private String cannotQueryValueOf(Describable displayName, String reason) {
            return this.cannot("query", displayName, reason);
        }

        private String cannot(String what, Describable displayName, String reason) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Cannot " + what + " the value of ");
            formatter.append((CharSequence)displayName.getDisplayName());
            formatter.append((CharSequence)" because ");
            formatter.append((CharSequence)reason);
            formatter.append((CharSequence)".");
            return formatter.toString();
        }
    }
}

