/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.console.UserInputReceiver;
import org.gradle.launcher.daemon.client.InputForwarder;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.InputMessage;
import org.gradle.launcher.daemon.protocol.UserResponse;

public class DaemonClientInputForwarder
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonClientInputForwarder.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final InputForwarder forwarder;
    private final GlobalUserInputReceiver userInput;

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super InputMessage> dispatch, GlobalUserInputReceiver userInput, ExecutorFactory executorFactory) {
        this(inputStream, dispatch, userInput, executorFactory, 8192);
    }

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super InputMessage> dispatch, GlobalUserInputReceiver userInput, ExecutorFactory executorFactory, int bufferSize) {
        this.userInput = userInput;
        ForwardTextStreamToConnection handler = new ForwardTextStreamToConnection(dispatch);
        this.forwarder = new InputForwarder(inputStream, handler, executorFactory, bufferSize);
        userInput.dispatchTo((UserInputReceiver)new ForwardingUserInput(handler));
    }

    public void start() {
        this.forwarder.start();
    }

    @Override
    public void stop() {
        this.userInput.stopDispatching();
        this.forwarder.stop();
    }

    private static class ForwardTextStreamToConnection
    implements TextStream {
        private final Dispatch<? super InputMessage> dispatch;
        private final AtomicReference<UserInputReceiver.Normalizer> pending = new AtomicReference();

        public ForwardTextStreamToConnection(Dispatch<? super InputMessage> dispatch) {
            this.dispatch = dispatch;
        }

        void forwardNextLineAsUserResponse(UserInputReceiver.Normalizer request) {
            if (!this.pending.compareAndSet(null, request)) {
                throw new IllegalStateException("Already expecting user input");
            }
        }

        @Override
        public void text(String input) {
            UserInputReceiver.Normalizer currentUserInputRequest;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Forwarding input to daemon: '{}'", (Object)input.replace("\n", "\\n"));
            }
            if ((currentUserInputRequest = this.pending.get()) != null) {
                String result = currentUserInputRequest.normalize(input);
                if (result != null) {
                    this.pending.set(null);
                    this.dispatch.dispatch((Object)new UserResponse(result));
                }
            } else {
                this.dispatch.dispatch((Object)new ForwardInput(input.getBytes()));
            }
        }

        @Override
        public void endOfStream(@Nullable Throwable failure) {
            CloseInput message = new CloseInput();
            LOGGER.debug("Dispatching close input message: {}", (Object)message);
            this.dispatch.dispatch((Object)message);
        }
    }

    private static class ForwardingUserInput
    implements UserInputReceiver {
        private final ForwardTextStreamToConnection handler;

        public ForwardingUserInput(ForwardTextStreamToConnection handler) {
            this.handler = handler;
        }

        public void readAndForwardText(UserInputReceiver.Normalizer normalizer) {
            this.handler.forwardNextLineAsUserResponse(normalizer);
        }
    }
}

