/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;
import org.gradle.internal.time.TimestampSuppliers;

public class DirectoryBuildCacheServiceFactory
implements BuildCacheServiceFactory<DirectoryBuildCache> {
    public static final String FAILED_READ_SUFFIX = ".failed";
    private static final String BUILD_CACHE_VERSION = "1";
    private static final String BUILD_CACHE_KEY = "build-cache-1";
    private static final String DIRECTORY_BUILD_CACHE_TYPE = "directory";
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final UnscopedCacheBuilderFactory unscopedCacheBuilderFactory;
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final PathToFileResolver resolver;
    private final CleanupActionDecorator cleanupActionDecorator;
    private final FileAccessTimeJournal fileAccessTimeJournal;
    private final CacheConfigurationsInternal cacheConfigurations;

    @Inject
    public DirectoryBuildCacheServiceFactory(UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, GlobalScopedCacheBuilderFactory cacheBuilderFactory, PathToFileResolver resolver, CleanupActionDecorator cleanupActionDecorator, FileAccessTimeJournal fileAccessTimeJournal, CacheConfigurationsInternal cacheConfigurations) {
        this.unscopedCacheBuilderFactory = unscopedCacheBuilderFactory;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.resolver = resolver;
        this.cleanupActionDecorator = cleanupActionDecorator;
        this.fileAccessTimeJournal = fileAccessTimeJournal;
        this.cacheConfigurations = cacheConfigurations;
    }

    public BuildCacheService createBuildCacheService(DirectoryBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        Object cacheDirectory = configuration.getDirectory();
        File target = cacheDirectory != null ? this.resolver.resolve(cacheDirectory) : this.cacheBuilderFactory.baseDirForCrossVersionCache(BUILD_CACHE_KEY);
        DirectoryBuildCacheServiceFactory.checkDirectory(target);
        int removeUnusedEntriesAfterDays = configuration.getRemoveUnusedEntriesAfterDays();
        describer.type(DIRECTORY_BUILD_CACHE_TYPE).config("location", target.getAbsolutePath()).config("removeUnusedEntriesAfter", removeUnusedEntriesAfterDays + " days");
        Supplier removeUnusedEntriesOlderThan = removeUnusedEntriesAfterDays == 7 ? this.cacheConfigurations.getBuildCache().getRemoveUnusedEntriesOlderThanAsSupplier() : TimestampSuppliers.daysAgo((int)removeUnusedEntriesAfterDays);
        PersistentCache persistentCache = this.unscopedCacheBuilderFactory.cache(target).withCleanupStrategy(this.createCacheCleanupStrategy(removeUnusedEntriesOlderThan)).withDisplayName("Build cache").withInitialLockMode(FileLockManager.LockMode.OnDemand).open();
        SingleDepthFileAccessTracker fileAccessTracker = new SingleDepthFileAccessTracker(this.fileAccessTimeJournal, target, 1);
        return new DirectoryBuildCacheService(persistentCache, (FileAccessTracker)fileAccessTracker, FAILED_READ_SUFFIX);
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(Supplier<Long> removeUnusedEntriesTimestamp) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)this.cleanupActionDecorator.decorate((CleanupAction)this.createCleanupAction(removeUnusedEntriesTimestamp)), () -> ((Provider)this.cacheConfigurations.getCleanupFrequency()).get());
    }

    private LeastRecentlyUsedCacheCleanup createCleanupAction(Supplier<Long> removeUnusedEntriesTimestamp) {
        return new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), this.fileAccessTimeJournal, removeUnusedEntriesTimestamp);
    }

    private static void checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
    }
}

