/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure.mappers;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.ThrowableToTestFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;

public class OpenTestAssertionFailedMapper
extends TestFailureMapper {
    @Override
    protected List<String> getSupportedClassNames() {
        return Collections.singletonList("org.opentest4j.AssertionFailedError");
    }

    @Override
    public TestFailure map(Throwable throwable, ThrowableToTestFailureMapper rootMapper) throws Exception {
        Object expectedValue = OpenTestAssertionFailedMapper.invokeMethod(OpenTestAssertionFailedMapper.invokeMethod(throwable, "getExpected"), "getValue");
        Object actualValue = OpenTestAssertionFailedMapper.invokeMethod(OpenTestAssertionFailedMapper.invokeMethod(throwable, "getActual"), "getValue");
        if (OpenTestAssertionFailedMapper.isFileInfo(expectedValue) || OpenTestAssertionFailedMapper.isFileInfo(actualValue)) {
            return OpenTestAssertionFailedMapper.mapFileInfoComparisonFailure(throwable, expectedValue, actualValue);
        }
        return OpenTestAssertionFailedMapper.mapStringBasedComparisonFailure(throwable, expectedValue, actualValue);
    }

    private static TestFailure mapFileInfoComparisonFailure(Throwable throwable, @Nullable Object expected, @Nullable Object actual) throws Exception {
        String expectedPath = OpenTestAssertionFailedMapper.getFilePathOrString(expected);
        byte[] expectedContent = OpenTestAssertionFailedMapper.getContentsOrNull(expected);
        String actualPath = OpenTestAssertionFailedMapper.getFilePathOrString(actual);
        byte[] actualContent = OpenTestAssertionFailedMapper.getContentsOrNull(actual);
        return TestFailure.fromFileComparisonFailure((Throwable)throwable, (String)expectedPath, (String)actualPath, (byte[])expectedContent, (byte[])actualContent, null);
    }

    private static TestFailure mapStringBasedComparisonFailure(Throwable throwable, @Nullable Object expected, @Nullable Object actual) throws Exception {
        String actualString = OpenTestAssertionFailedMapper.getFilePathOrString(actual);
        String expectedString = OpenTestAssertionFailedMapper.getFilePathOrString(expected);
        return TestFailure.fromTestAssertionFailure((Throwable)throwable, (String)expectedString, (String)actualString);
    }

    private static boolean isFileInfo(@Nullable Object value) {
        return value != null && "org.opentest4j.FileInfo".equals(value.getClass().getName());
    }

    @Nullable
    private static String getFilePathOrString(@Nullable Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (OpenTestAssertionFailedMapper.isFileInfo(value)) {
            return OpenTestAssertionFailedMapper.invokeMethod(value, "getPath", String.class);
        }
        return value.toString();
    }

    @Nullable
    private static byte[] getContentsOrNull(@Nullable Object value) throws Exception {
        if (OpenTestAssertionFailedMapper.isFileInfo(value)) {
            return OpenTestAssertionFailedMapper.invokeMethod(value, "getContents", byte[].class);
        }
        return null;
    }
}

