/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.ExpressionResolver;
import org.gradle.internal.declarativedsl.analysis.FunctionCallResolver;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.PropertyAccessResolver;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.FunctionCall;
import org.gradle.internal.declarativedsl.language.Literal;
import org.gradle.internal.declarativedsl.language.Null;
import org.gradle.internal.declarativedsl.language.PropertyAccess;
import org.gradle.internal.declarativedsl.language.This;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolverImpl;", "Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;", "propertyAccessResolver", "Lorg/gradle/internal/declarativedsl/analysis/PropertyAccessResolver;", "functionCallResolver", "Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;", "(Lorg/gradle/internal/declarativedsl/analysis/PropertyAccessResolver;Lorg/gradle/internal/declarativedsl/analysis/FunctionCallResolver;)V", "doResolveExpression", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "expr", "Lorg/gradle/internal/declarativedsl/language/Expr;", "literalObjectOrigin", "T", "", "literalExpr", "Lorg/gradle/internal/declarativedsl/language/Literal;", "declarative-dsl-core"})
public final class ExpressionResolverImpl
implements ExpressionResolver {
    @NotNull
    private final PropertyAccessResolver propertyAccessResolver;
    @NotNull
    private final FunctionCallResolver functionCallResolver;

    public ExpressionResolverImpl(@NotNull PropertyAccessResolver propertyAccessResolver, @NotNull FunctionCallResolver functionCallResolver) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessResolver, (String)"propertyAccessResolver");
        Intrinsics.checkNotNullParameter((Object)functionCallResolver, (String)"functionCallResolver");
        this.propertyAccessResolver = propertyAccessResolver;
        this.functionCallResolver = functionCallResolver;
    }

    @Override
    @Nullable
    public ObjectOrigin doResolveExpression(@NotNull AnalysisContext context, @NotNull Expr expr) {
        ObjectOrigin objectOrigin;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        AnalysisContext $this$doResolveExpression_u24lambda_u240 = context;
        boolean bl = false;
        Expr expr2 = expr;
        if (expr2 instanceof PropertyAccess) {
            objectOrigin = this.propertyAccessResolver.doResolvePropertyAccessToObjectOrigin(context, (PropertyAccess)expr);
        } else if (expr2 instanceof FunctionCall) {
            objectOrigin = this.functionCallResolver.doResolveFunctionCall(context, (FunctionCall)expr);
        } else if (expr2 instanceof Literal) {
            objectOrigin = this.literalObjectOrigin((Literal)expr);
        } else if (expr2 instanceof Null) {
            objectOrigin = new ObjectOrigin.NullObjectOrigin((Null)expr);
        } else if (expr2 instanceof This) {
            objectOrigin = ((AnalysisScope)CollectionsKt.last($this$doResolveExpression_u24lambda_u240.getCurrentScopes())).getReceiver();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return objectOrigin;
    }

    private final <T> ObjectOrigin literalObjectOrigin(Literal<T> literalExpr) {
        return new ObjectOrigin.ConstantOrigin(literalExpr);
    }
}

