/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import org.gradle.api.file.BuildLayout;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.DefaultCacheConfigurations;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.DefaultBuildLayout;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DefaultPluginManager;
import org.gradle.api.internal.plugins.ImperativeOnlyPluginTarget;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.SoftwareTypeRegistrationPluginTarget;
import org.gradle.api.model.ObjectFactory;
import org.gradle.cache.internal.LegacyCacheCleanupEnablement;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleModuleServices;
import org.gradle.plugin.software.internal.PluginScheme;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;

public class SettingsScopeServices
extends DefaultServiceRegistry {
    private final SettingsInternal settings;

    public SettingsScopeServices(ServiceRegistry parent, SettingsInternal settings) {
        super(new ServiceRegistry[]{parent});
        this.settings = settings;
        this.register(registration -> {
            for (GradleModuleServices services : parent.getAll(GradleModuleServices.class)) {
                services.registerSettingsServices(registration);
            }
            registration.add(DefaultProjectDescriptorRegistry.class);
        });
    }

    @Provides
    protected BuildLayout createBuildLayout(FileFactory fileFactory) {
        return new DefaultBuildLayout(this.settings, fileFactory);
    }

    @Provides
    protected FileResolver createFileResolver(FileLookup fileLookup) {
        return fileLookup.getFileResolver(this.settings.getSettingsDir());
    }

    @Provides
    protected PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild(this.settings.getClassLoaderScope());
    }

    @Provides
    protected PluginManagerInternal createPluginManager(Instantiator instantiator, PluginRegistry pluginRegistry, InstantiatorFactory instantiatorFactory, BuildOperationRunner buildOperationRunner, UserCodeApplicationContext userCodeApplicationContext, CollectionCallbackActionDecorator decorator, DomainObjectCollectionFactory domainObjectCollectionFactory, PluginScheme pluginScheme, SoftwareTypeRegistry softwareTypeRegistry) {
        SoftwareTypeRegistrationPluginTarget target = new SoftwareTypeRegistrationPluginTarget(new ImperativeOnlyPluginTarget<SettingsInternal>(this.settings), softwareTypeRegistry, pluginScheme.getInspectionScheme());
        return (PluginManagerInternal)instantiator.newInstance(DefaultPluginManager.class, new Object[]{pluginRegistry, instantiatorFactory.inject((ServiceLookup)this), target, buildOperationRunner, userCodeApplicationContext, decorator, domainObjectCollectionFactory});
    }

    @Provides
    protected ConfigurationTargetIdentifier createConfigurationTargetIdentifier() {
        return ConfigurationTargetIdentifier.of(this.settings);
    }

    @Provides
    protected GradleInternal createGradleInternal() {
        return this.settings.getGradle();
    }

    @Provides
    protected CacheConfigurationsInternal createCacheConfigurations(ObjectFactory objectFactory, CacheConfigurationsInternal persistentCacheConfigurations, GradleInternal gradleInternal, LegacyCacheCleanupEnablement legacyCacheCleanupEnablement) {
        CacheConfigurationsInternal cacheConfigurations = (CacheConfigurationsInternal)objectFactory.newInstance(DefaultCacheConfigurations.class, new Object[]{legacyCacheCleanupEnablement});
        if (gradleInternal.isRootBuild()) {
            cacheConfigurations.synchronize(persistentCacheConfigurations);
            persistentCacheConfigurations.setCleanupHasBeenConfigured(false);
        }
        return cacheConfigurations;
    }
}

