/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadataComparator;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;
import org.gradle.jvm.toolchain.internal.JvmInstallationMetadataMatcher;
import org.gradle.jvm.toolchain.internal.NoToolchainAvailableException;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;
import org.gradle.jvm.toolchain.internal.ToolchainDownloadFailedException;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.platform.BuildPlatform;

@ServiceScope(value={Scope.Project.class})
public class JavaToolchainQueryService {
    private static final JavaToolchainSpecInternal.Key FALLBACK_TOOLCHAIN_KEY = new JavaToolchainSpecInternal.Key(){

        public String toString() {
            return "FallbackToolchainSpecKey";
        }
    };
    private final JavaInstallationRegistry registry;
    private final FileFactory fileFactory;
    private final JvmMetadataDetector detector;
    private final JavaToolchainProvisioningService installService;
    private final ConcurrentMap<JavaToolchainSpecInternal.Key, Object> matchingToolchains;
    private final CurrentJvmToolchainSpec fallbackToolchainSpec;
    private final File currentJavaHome;
    private final BuildPlatform buildPlatform;

    @Inject
    public JavaToolchainQueryService(JavaInstallationRegistry registry, JvmMetadataDetector detector, FileFactory fileFactory, JavaToolchainProvisioningService provisioningService, ObjectFactory objectFactory, BuildPlatform buildPlatform) {
        this(registry, detector, fileFactory, provisioningService, objectFactory, Jvm.current().getJavaHome(), buildPlatform);
    }

    @VisibleForTesting
    JavaToolchainQueryService(JavaInstallationRegistry registry, JvmMetadataDetector detector, FileFactory fileFactory, JavaToolchainProvisioningService provisioningService, ObjectFactory objectFactory, File currentJavaHome, BuildPlatform buildPlatform) {
        this.registry = registry;
        this.detector = detector;
        this.fileFactory = fileFactory;
        this.installService = provisioningService;
        this.matchingToolchains = new ConcurrentHashMap<JavaToolchainSpecInternal.Key, Object>();
        this.fallbackToolchainSpec = (CurrentJvmToolchainSpec)objectFactory.newInstance(CurrentJvmToolchainSpec.class, new Object[0]);
        this.currentJavaHome = currentJavaHome;
        this.buildPlatform = buildPlatform;
    }

    public ProviderInternal<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        JavaToolchainSpecInternal filterInternal = (JavaToolchainSpecInternal)Objects.requireNonNull(filter);
        return new DefaultProvider(() -> this.resolveToolchain(filterInternal));
    }

    private JavaToolchain resolveToolchain(JavaToolchainSpecInternal requestedSpec) throws Exception {
        JavaToolchainSpecInternal actualSpec;
        requestedSpec.finalizeProperties();
        if (!requestedSpec.isValid()) {
            throw ((DocumentedFailure.Builder)DocumentedFailure.builder().withSummary("Using toolchain specifications without setting a language version is not supported.").withAdvice("Consider configuring the language version.").withUpgradeGuideSection(7, "invalid_toolchain_specification_deprecation")).build();
        }
        boolean useFallback = !requestedSpec.isConfigured();
        JavaToolchainSpecInternal.Key actualKey = useFallback ? FALLBACK_TOOLCHAIN_KEY : requestedSpec.toKey();
        Object resolutionResult = this.matchingToolchains.computeIfAbsent(actualKey, arg_0 -> this.lambda$resolveToolchain$1(actualSpec = useFallback ? this.fallbackToolchainSpec : requestedSpec, useFallback, arg_0));
        if (resolutionResult instanceof Exception) {
            throw (Exception)resolutionResult;
        }
        return (JavaToolchain)resolutionResult;
    }

    private JavaToolchain query(JavaToolchainSpec spec, boolean isFallback) {
        if (spec instanceof CurrentJvmToolchainSpec) {
            return this.asToolchainOrThrow(InstallationLocation.autoDetected((File)this.currentJavaHome, (String)"current JVM"), spec, isFallback);
        }
        if (spec instanceof SpecificInstallationToolchainSpec) {
            return this.asToolchainOrThrow(InstallationLocation.userDefined((File)((SpecificInstallationToolchainSpec)spec).getJavaHome(), (String)"specific installation"), spec, false);
        }
        return this.findInstalledToolchain(spec).orElseGet(() -> this.downloadToolchain(spec));
    }

    private Optional<JavaToolchain> findInstalledToolchain(JavaToolchainSpec spec) {
        JvmInstallationMetadataMatcher matcher = new JvmInstallationMetadataMatcher(spec);
        return this.registry.toolchains().stream().filter(result -> result.metadata.isValidInstallation()).filter(arg_0 -> JavaToolchainQueryService.lambda$findInstalledToolchain$4((Predicate)matcher, arg_0)).min(Comparator.comparing(result -> result.metadata, new JvmInstallationMetadataComparator(this.currentJavaHome))).map(result -> {
            this.warnIfAutoProvisionedToolchainUsedWithoutRepositoryDefinitions(result.location);
            return new JavaToolchain(result.metadata, this.fileFactory, new JavaToolchainInput(spec), false);
        });
    }

    private void warnIfAutoProvisionedToolchainUsedWithoutRepositoryDefinitions(InstallationLocation javaHome) {
        boolean autoDetectedToolchain = javaHome.isAutoProvisioned();
        if (autoDetectedToolchain && this.installService.isAutoDownloadEnabled() && !this.installService.hasConfiguredToolchainRepositories()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.warnOfChangedBehaviour((String)"Using a toolchain installed via auto-provisioning, but having no toolchain repositories configured", (String)("Consider defining toolchain download repositories, otherwise the build might fail in clean environments; see " + Documentation.userManual((String)"toolchains", (String)"sub:download_repositories").getUrl())).withUserManual("toolchains", "sub:download_repositories")).nagUser();
        }
    }

    private JavaToolchain downloadToolchain(JavaToolchainSpec spec) {
        File installation;
        try {
            installation = this.installService.tryInstall(spec);
        }
        catch (ToolchainDownloadFailedException e) {
            throw new NoToolchainAvailableException(spec, this.buildPlatform, e);
        }
        InstallationLocation downloadedInstallation = InstallationLocation.autoProvisioned((File)installation, (String)"provisioned toolchain");
        JavaToolchain downloadedToolchain = this.asToolchainOrThrow(downloadedInstallation, spec, false);
        this.registry.addInstallation(downloadedInstallation);
        return downloadedToolchain;
    }

    private JavaToolchain asToolchainOrThrow(InstallationLocation javaHome, JavaToolchainSpec spec, boolean isFallback) {
        JvmInstallationMetadata metadata = this.detector.getMetadata(javaHome);
        if (metadata.isValidInstallation()) {
            return new JavaToolchain(metadata, this.fileFactory, new JavaToolchainInput(spec), isFallback);
        }
        throw new GradleException("Toolchain installation '" + javaHome.getLocation() + "' could not be probed: " + metadata.getErrorMessage(), metadata.getErrorCause());
    }

    private static /* synthetic */ boolean lambda$findInstalledToolchain$4(Predicate matcher, JvmToolchainMetadata result) {
        return matcher.test(result.metadata);
    }

    private /* synthetic */ Object lambda$resolveToolchain$1(JavaToolchainSpecInternal actualSpec, boolean useFallback, JavaToolchainSpecInternal.Key key) {
        try {
            return this.query((JavaToolchainSpec)actualSpec, useFallback);
        }
        catch (Exception e) {
            return e;
        }
    }
}

