/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.lang.ref.SoftReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.ModelContainer;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder,
HoldsProjectState {
    private final DependencyMetaDataProvider metadataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ConfigurationsProvider configurationsProvider;
    private final MetadataHolder holder;
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
    private final Factory factory;

    private DefaultRootComponentMetadataBuilder(DependencyMetaDataProvider metadataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ConfigurationsProvider configurationsProvider, ProjectStateRegistry projectStateRegistry, LocalComponentGraphResolveStateFactory localResolveStateFactory, Factory factory) {
        this.metadataProvider = metadataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.configurationsProvider = configurationsProvider;
        this.projectStateRegistry = projectStateRegistry;
        this.localResolveStateFactory = localResolveStateFactory;
        this.factory = factory;
        this.holder = new MetadataHolder();
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent(String configurationName) {
        ComponentIdentifier componentIdentifier;
        Module module = this.metadataProvider.getModule();
        final LocalComponentGraphResolveState state = this.getComponentState(module, componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module));
        ConfigurationGraphResolveState configuration = state.getConfiguration(configurationName);
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Expected configuration '%s' to be present in %s", configurationName, componentIdentifier));
        }
        final VariantGraphResolveState rootVariant = configuration.asVariant();
        return new RootComponentMetadataBuilder.RootComponentState(){

            @Override
            public LocalComponentGraphResolveState getRootComponent() {
                return state;
            }

            @Override
            public VariantGraphResolveState getRootVariant() {
                return rootVariant;
            }
        };
    }

    private LocalComponentGraphResolveState getComponentState(Module module, ComponentIdentifier componentIdentifier) {
        LocalComponentGraphResolveState state = this.holder.tryCached(componentIdentifier);
        if (state == null) {
            state = this.createComponentState(module, componentIdentifier);
            this.holder.cache(state, this.shouldCacheResolutionState());
        }
        return state;
    }

    private LocalComponentGraphResolveState createComponentState(Module module, ComponentIdentifier componentIdentifier) {
        ProjectComponentIdentifier projectId = module.getProjectId();
        if (projectId != null) {
            ProjectState projectState = this.projectStateRegistry.stateFor(projectId);
            if (!projectState.hasMutableState()) {
                throw new IllegalStateException("Thread should hold project lock for " + projectState.getDisplayName());
            }
            return (LocalComponentGraphResolveState)projectState.fromMutableState(project -> {
                AttributesSchemaInternal schema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
                return this.createRootComponentMetadata(module, componentIdentifier, schema, project.getModel());
            });
        }
        return this.createRootComponentMetadata(module, componentIdentifier, EmptySchema.INSTANCE, (ModelContainer<?>)RootScriptDomainObjectContext.INSTANCE);
    }

    private LocalComponentGraphResolveState createRootComponentMetadata(Module module, ComponentIdentifier componentIdentifier, AttributesSchemaInternal schema, ModelContainer<?> model) {
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        if (this.shouldCacheResolutionState()) {
            return this.localResolveStateFactory.stateFor(model, componentIdentifier, moduleVersionIdentifier, this.configurationsProvider, module.getStatus(), schema);
        }
        return this.localResolveStateFactory.adHocStateFor(model, componentIdentifier, moduleVersionIdentifier, this.configurationsProvider, module.getStatus(), schema);
    }

    private boolean shouldCacheResolutionState() {
        return !this.configurationsProvider.isFixedSize() || this.configurationsProvider.size() > 1;
    }

    @Override
    public RootComponentMetadataBuilder withConfigurationsProvider(ConfigurationsProvider provider) {
        return this.factory.create(provider);
    }

    @Override
    public MutationValidator getValidator() {
        return this.holder;
    }

    public void discardAll() {
        this.holder.discard();
    }

    public static class Factory {
        private final DependencyMetaDataProvider metaDataProvider;
        private final ComponentIdentifierFactory componentIdentifierFactory;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final ProjectStateRegistry projectStateRegistry;
        private final LocalComponentGraphResolveStateFactory localResolveStateFactory;

        @Inject
        public Factory(DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ProjectStateRegistry projectStateRegistry, LocalComponentGraphResolveStateFactory localResolveStateFactory) {
            this.metaDataProvider = metaDataProvider;
            this.componentIdentifierFactory = componentIdentifierFactory;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.projectStateRegistry = projectStateRegistry;
            this.localResolveStateFactory = localResolveStateFactory;
        }

        public RootComponentMetadataBuilder create(ConfigurationsProvider configurationsProvider) {
            return new DefaultRootComponentMetadataBuilder(this.metaDataProvider, this.componentIdentifierFactory, this.moduleIdentifierFactory, configurationsProvider, this.projectStateRegistry, this.localResolveStateFactory, this);
        }
    }

    private static class MetadataHolder
    implements MutationValidator {
        @Nullable
        private SoftReference<LocalComponentGraphResolveState> reference;
        @Nullable
        private LocalComponentGraphResolveState cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            LocalComponentGraphResolveState value;
            if (type != MutationValidator.MutationType.STRATEGY && (value = this.currentValue()) != null) {
                value.reevaluate();
            }
        }

        @Nullable
        LocalComponentGraphResolveState tryCached(ComponentIdentifier id) {
            LocalComponentGraphResolveState value = this.currentValue();
            assert (value == null || value.getId().equals(id));
            return value;
        }

        @Nullable
        private LocalComponentGraphResolveState currentValue() {
            if (this.reference != null) {
                return this.reference.get();
            }
            return this.cachedValue;
        }

        public void discard() {
            this.reference = null;
            this.cachedValue = null;
        }

        public void cache(LocalComponentGraphResolveState state, boolean useStrongReference) {
            if (useStrongReference) {
                this.reference = null;
                this.cachedValue = state;
            } else {
                this.reference = new SoftReference<LocalComponentGraphResolveState>(state);
                this.cachedValue = null;
            }
        }
    }
}

