/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.File;
import org.gradle.internal.agents.AgentInitializer;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonProcessState;
import org.gradle.launcher.daemon.server.MasterExpirationStrategy;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class ForegroundDaemonAction
implements Runnable {
    private final ServiceRegistry loggingRegistry;
    private final DaemonServerConfiguration configuration;

    public ForegroundDaemonAction(ServiceRegistry loggingRegistry, DaemonServerConfiguration configuration) {
        this.loggingRegistry = loggingRegistry;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)this.loggingRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.start();
        DaemonProcessState daemonProcessState = new DaemonProcessState(this.configuration, this.loggingRegistry, loggingManager, DefaultClassPath.of((File[])new File[0]));
        ServiceRegistry daemonServices = daemonProcessState.getServices();
        Daemon daemon = (Daemon)daemonServices.get(Daemon.class);
        DaemonRegistry daemonRegistry = (DaemonRegistry)daemonServices.get(DaemonRegistry.class);
        DaemonExpirationStrategy expirationStrategy = (DaemonExpirationStrategy)daemonServices.get(MasterExpirationStrategy.class);
        ((AgentInitializer)daemonServices.get(AgentInitializer.class)).maybeConfigureInstrumentationAgent();
        daemon.start();
        try {
            daemonRegistry.markState(daemon.getAddress(), DaemonStateControl.State.Idle);
            daemon.stopOnExpiration(expirationStrategy, this.configuration.getPeriodicCheckIntervalMs());
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable((Object[])new Object[]{daemon, daemonProcessState}).stop();
            throw throwable;
        }
        CompositeStoppable.stoppable((Object[])new Object[]{daemon, daemonProcessState}).stop();
    }
}

