/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.cc.impl.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.internal.cc.impl.problems.UniquePropertyProblem;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u001a0\u001a2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u001a\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001cJ \u0010#\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0003H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/gradle/internal/cc/impl/problems/Summary;", "", "problemCount", "", "failureCount", "suppressedCount", "uniqueProblems", "", "Lorg/gradle/internal/cc/impl/problems/UniquePropertyProblem;", "causes", "", "", "overflowed", "", "maxCollectedProblems", "(IIILjava/util/Set;Ljava/util/List;ZI)V", "getCauses", "()Ljava/util/List;", "getFailureCount", "()I", "nonSuppressedProblemCount", "getNonSuppressedProblemCount", "getProblemCount", "uniqueProblemCount", "getUniqueProblemCount", "buildSummaryReportLink", "", "reportFile", "Ljava/io/File;", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "textForConsole", "cacheActionText", "htmlReportFile", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "totalProblemCount", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblemsSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/Summary\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1855#2,2:243\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/Summary\n*L\n168#1:243,2\n*E\n"})
public final class Summary {
    private final int problemCount;
    private final int failureCount;
    private final int suppressedCount;
    @NotNull
    private final Set<UniquePropertyProblem> uniqueProblems;
    @NotNull
    private final List<Throwable> causes;
    private final boolean overflowed;
    private final int maxCollectedProblems;

    public Summary(int problemCount, int failureCount, int suppressedCount, @NotNull Set<UniquePropertyProblem> uniqueProblems, @NotNull List<? extends Throwable> causes, boolean overflowed, int maxCollectedProblems) {
        Intrinsics.checkNotNullParameter(uniqueProblems, (String)"uniqueProblems");
        Intrinsics.checkNotNullParameter(causes, (String)"causes");
        this.problemCount = problemCount;
        this.failureCount = failureCount;
        this.suppressedCount = suppressedCount;
        this.uniqueProblems = uniqueProblems;
        this.causes = causes;
        this.overflowed = overflowed;
        this.maxCollectedProblems = maxCollectedProblems;
    }

    public final int getProblemCount() {
        return this.problemCount;
    }

    public final int getFailureCount() {
        return this.failureCount;
    }

    @NotNull
    public final List<Throwable> getCauses() {
        return this.causes;
    }

    public final int getUniqueProblemCount() {
        return this.uniqueProblems.size();
    }

    public final int getNonSuppressedProblemCount() {
        return this.problemCount - this.suppressedCount;
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @Nullable File htmlReportFile) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        StringBuilder $this$textForConsole_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$textForConsole_u24lambda_u243.append('\n'), (String)"append(...)");
        this.appendSummaryHeader($this$textForConsole_u24lambda_u243, cacheActionText, this.problemCount);
        Intrinsics.checkNotNullExpressionValue((Object)$this$textForConsole_u24lambda_u243.append('\n'), (String)"append(...)");
        List list = Ordering.from((Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparator()).leastOf((Iterable)this.uniqueProblems, 15);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"from(consoleComparator()\u2026lems, maxConsoleProblems)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            UniquePropertyProblem problem2 = (UniquePropertyProblem)element$iv;
            boolean bl2 = false;
            $this$textForConsole_u24lambda_u243.append("- ");
            $this$textForConsole_u24lambda_u243.append(CharSequenceExtensionsKt.capitalized((CharSequence)problem2.getUserCodeLocation()));
            $this$textForConsole_u24lambda_u243.append(": ");
            StringBuilder stringBuilder2 = $this$textForConsole_u24lambda_u243.append(problem2.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            if (problem2.getDocumentationSection() == null) continue;
            boolean bl3 = false;
            StringBuilder stringBuilder3 = $this$textForConsole_u24lambda_u243.append("  See " + documentationRegistry.getDocumentationFor("configuration_cache", it));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        if (this.getUniqueProblemCount() > 15) {
            StringBuilder stringBuilder4 = $this$textForConsole_u24lambda_u243.append("plus " + (this.getUniqueProblemCount() - 15) + " more problems. Please see the report for details.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        File file = htmlReportFile;
        if (file != null) {
            File it = file;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$textForConsole_u24lambda_u243.append('\n'), (String)"append(...)");
            $this$textForConsole_u24lambda_u243.append(this.buildSummaryReportLink(it));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply {\n\u2026   }\n        }.toString()");
        return string2;
    }

    public static /* synthetic */ String textForConsole$default(Summary summary, String string2, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return summary.textForConsole(string2, file);
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction, int totalProblemCount) {
        $this$appendSummaryHeader.append(totalProblemCount);
        $this$appendSummaryHeader.append(totalProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (this.overflowed) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(this.maxCollectedProblems);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (totalProblemCount != this.getUniqueProblemCount()) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(this.getUniqueProblemCount());
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(this.getUniqueProblemCount() == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile2) {
        return "See the complete report at " + this.clickableUrlFor(reportFile2);
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }
}

