/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.internal.cc.impl.serialize.ClassLoaderScopeSpec;
import org.gradle.internal.cc.impl.serialize.ClassPathEncodingExtensionsKt;
import org.gradle.internal.cc.impl.serialize.ScopeLookup;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.ClassEncoder;
import org.gradle.internal.serialize.graph.ClassLoaderRole;
import org.gradle.internal.serialize.graph.WriteContext;
import org.gradle.internal.serialize.graph.WriteIdentities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t*\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0016\u0010\r\u001a\u00020\t*\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gradle/internal/cc/impl/serialize/DefaultClassEncoder;", "Lorg/gradle/internal/serialize/graph/ClassEncoder;", "scopeLookup", "Lorg/gradle/internal/cc/impl/serialize/ScopeLookup;", "(Lorg/gradle/internal/cc/impl/serialize/ScopeLookup;)V", "classes", "Lorg/gradle/internal/serialize/graph/WriteIdentities;", "scopes", "encodeClass", "", "Lorg/gradle/internal/serialize/graph/WriteContext;", "type", "Ljava/lang/Class;", "writeHashCode", "hashCode", "Lorg/gradle/internal/hash/HashCode;", "writeScope", "scope", "Lorg/gradle/internal/cc/impl/serialize/ClassLoaderScopeSpec;", "configuration-cache"})
public final class DefaultClassEncoder
implements ClassEncoder {
    @NotNull
    private final ScopeLookup scopeLookup;
    @NotNull
    private final WriteIdentities classes;
    @NotNull
    private final WriteIdentities scopes;

    public DefaultClassEncoder(@NotNull ScopeLookup scopeLookup) {
        Intrinsics.checkNotNullParameter((Object)scopeLookup, (String)"scopeLookup");
        this.scopeLookup = scopeLookup;
        this.classes = new WriteIdentities();
        this.scopes = new WriteIdentities();
    }

    public void encodeClass(@NotNull WriteContext $this$encodeClass, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeClass, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Integer id = this.classes.getId(type);
        if (id != null) {
            $this$encodeClass.writeSmallInt(id.intValue());
        } else {
            Pair<ClassLoaderScopeSpec, ClassLoaderRole> scope = this.scopeLookup.scopeFor(type.getClassLoader());
            int newId = this.classes.putInstance(type);
            $this$encodeClass.writeSmallInt(newId);
            $this$encodeClass.writeString((CharSequence)type.getName());
            if (scope == null) {
                $this$encodeClass.writeBoolean(false);
            } else {
                $this$encodeClass.writeBoolean(true);
                this.writeScope($this$encodeClass, (ClassLoaderScopeSpec)scope.getFirst());
                $this$encodeClass.writeBoolean(((ClassLoaderRole)scope.getSecond()).unbox-impl());
            }
        }
    }

    private final void writeScope(WriteContext $this$writeScope, ClassLoaderScopeSpec scope) {
        Integer id = this.scopes.getId((Object)scope);
        if (id != null) {
            $this$writeScope.writeSmallInt(id.intValue());
        } else {
            int newId = this.scopes.putInstance((Object)scope);
            $this$writeScope.writeSmallInt(newId);
            if (scope.getParent() == null) {
                $this$writeScope.writeBoolean(false);
            } else {
                $this$writeScope.writeBoolean(true);
                this.writeScope($this$writeScope, scope.getParent());
            }
            $this$writeScope.writeString((CharSequence)scope.getName());
            if (scope.getOrigin() instanceof ClassLoaderScopeOrigin.Script) {
                $this$writeScope.writeBoolean(true);
                $this$writeScope.writeString((CharSequence)((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getFileName());
                $this$writeScope.writeString((CharSequence)((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getLongDisplayName().getDisplayName());
                $this$writeScope.writeString((CharSequence)((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getShortDisplayName().getDisplayName());
            } else {
                $this$writeScope.writeBoolean(false);
            }
            ClassPathEncodingExtensionsKt.writeClassPath((Encoder)$this$writeScope, scope.getLocalClassPath());
            this.writeHashCode($this$writeScope, scope.getLocalImplementationHash());
            ClassPathEncodingExtensionsKt.writeClassPath((Encoder)$this$writeScope, scope.getExportClassPath());
        }
    }

    private final void writeHashCode(WriteContext $this$writeHashCode, HashCode hashCode) {
        if (hashCode == null) {
            $this$writeHashCode.writeBoolean(false);
        } else {
            $this$writeHashCode.writeBoolean(true);
            $this$writeHashCode.writeBinary(hashCode.toByteArray());
        }
    }
}

