/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.ResolutionFailureHandler;
import org.gradle.internal.component.external.model.ExternalComponentGraphResolveMetadata;
import org.gradle.internal.component.external.model.ExternalComponentGraphResolveState;
import org.gradle.internal.component.external.model.ExternalComponentResolveMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultExternalComponentGraphResolveState<G extends ExternalComponentGraphResolveMetadata, A extends ExternalComponentResolveMetadata>
extends AbstractComponentGraphResolveState<G>
implements ExternalComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final A legacyMetadata;
    private final ConcurrentMap<ModuleConfigurationMetadata, DefaultConfigurationGraphResolveState> variants = new ConcurrentHashMap<ModuleConfigurationMetadata, DefaultConfigurationGraphResolveState>();
    private final Lazy<List<? extends VariantGraphResolveState>> allVariantsForGraphResolution;
    private final List<ResolvedVariantResult> selectableVariantResults;

    public DefaultExternalComponentGraphResolveState(long instanceId, G graphMetadata, A legacyMetadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator) {
        super(instanceId, graphMetadata, attributeDesugaring);
        this.legacyMetadata = legacyMetadata;
        this.allVariantsForGraphResolution = Lazy.locking().of(() -> graphMetadata.getVariantsForGraphTraversal().stream().map(ModuleConfigurationMetadata.class::cast).map(variant -> this.resolveStateFor((ModuleConfigurationMetadata)variant).asVariant()).collect(Collectors.toList()));
        this.idGenerator = idGenerator;
        this.selectableVariantResults = graphMetadata.getVariantsForGraphTraversal().stream().flatMap(variant -> variant.getVariants().stream()).map(variant -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    @Deprecated
    public A getLegacyMetadata() {
        return this.legacyMetadata;
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        A legacyMetadata = this.getLegacyMetadata();
        return new ExternalArtifactResolveMetadata((ExternalComponentResolveMetadata)legacyMetadata);
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return this.selectableVariantResults;
    }

    @Override
    public GraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        return new ExternalGraphSelectionCandidates(this);
    }

    @Override
    public Set<String> getConfigurationNames() {
        return ((ExternalComponentGraphResolveMetadata)this.getMetadata()).getConfigurationNames();
    }

    @Override
    @Nullable
    public ConfigurationGraphResolveState getConfiguration(String configurationName) {
        ModuleConfigurationMetadata configuration = (ModuleConfigurationMetadata)((ExternalComponentGraphResolveMetadata)this.getMetadata()).getConfiguration(configurationName);
        if (configuration == null) {
            return null;
        }
        return this.resolveStateFor(configuration);
    }

    private DefaultConfigurationGraphResolveState resolveStateFor(ModuleConfigurationMetadata configuration) {
        return this.variants.computeIfAbsent(configuration, c -> this.newVariantState(configuration));
    }

    protected VariantGraphResolveState newResolveStateFor(ModuleConfigurationMetadata configuration) {
        return this.newVariantState(configuration);
    }

    private DefaultConfigurationGraphResolveState newVariantState(ModuleConfigurationMetadata configuration) {
        return new DefaultConfigurationGraphResolveState(this.idGenerator.nextVariantId(), this, configuration);
    }

    private static class ExternalGraphSelectionCandidates
    implements GraphSelectionCandidates {
        private final List<? extends VariantGraphResolveState> variants;
        private final DefaultExternalComponentGraphResolveState<?, ?> component;

        public ExternalGraphSelectionCandidates(DefaultExternalComponentGraphResolveState<?, ?> component) {
            this.variants = (List)((DefaultExternalComponentGraphResolveState)component).allVariantsForGraphResolution.get();
            this.component = component;
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.variants;
        }

        @Override
        @Nullable
        public VariantGraphResolveState getVariantByConfigurationName(String name, ResolutionFailureHandler failureHandler) {
            ConfigurationGraphResolveState conf = this.component.getConfiguration(name);
            if (conf == null) {
                return null;
            }
            assert (conf.getMetadata().isCanBeConsumed()) : "External components' configurations are always consumable";
            return conf.asVariant();
        }
    }

    protected static class ExternalArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ExternalComponentResolveMetadata metadata;

        public ExternalArtifactResolveMetadata(ExternalComponentResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    private static class DefaultConfigurationArtifactResolveState
    implements VariantArtifactResolveState {
        private final ComponentArtifactResolveMetadata artifactMetadata;
        private final ConfigurationMetadata graphSelectedConfiguration;
        private final Set<? extends VariantResolveMetadata> variants;

        public DefaultConfigurationArtifactResolveState(ComponentArtifactResolveMetadata artifactMetadata, ConfigurationMetadata graphSelectedConfiguration) {
            this.artifactMetadata = artifactMetadata;
            this.graphSelectedConfiguration = graphSelectedConfiguration;
            this.variants = graphSelectedConfiguration.getVariants();
        }

        @Override
        public ResolvedVariant resolveAdhocVariant(VariantArtifactResolver variantResolver, List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.graphSelectedConfiguration.artifact(dependencyArtifact));
            }
            return variantResolver.resolveAdhocVariant(this.artifactMetadata, (ImmutableList<? extends ComponentArtifactMetadata>)artifacts.build());
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            return this.variants;
        }
    }

    private static class DefaultConfigurationGraphResolveState
    extends AbstractComponentGraphResolveState.AbstractVariantGraphResolveState
    implements VariantGraphResolveState,
    ConfigurationGraphResolveState {
        private final long instanceId;
        private final ModuleConfigurationMetadata configuration;
        private final Lazy<DefaultConfigurationArtifactResolveState> artifactResolveState;

        public DefaultConfigurationGraphResolveState(long instanceId, AbstractComponentGraphResolveState<?> componentState, ModuleConfigurationMetadata configuration) {
            super(componentState);
            this.instanceId = instanceId;
            this.configuration = configuration;
            this.artifactResolveState = Lazy.locking().of(() -> new DefaultConfigurationArtifactResolveState(componentState.prepareForArtifactResolution().getArtifactMetadata(), configuration));
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.configuration.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.configuration.getCapabilities();
        }

        @Override
        public ConfigurationGraphResolveMetadata getMetadata() {
            return this.configuration;
        }

        @Override
        public VariantGraphResolveState asVariant() {
            return this;
        }

        @Override
        public VariantArtifactGraphResolveMetadata resolveArtifacts() {
            return this.configuration;
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            return (VariantArtifactResolveState)this.artifactResolveState.get();
        }
    }
}

