/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.internal.component.local.model.TransformedComponentFileArtifactIdentifier;

public class InstrumentationClasspathMerger {
    public static List<File> mergeToClasspath(ArtifactCollection originalDependencies, ArtifactCollection externalDependencies, ArtifactCollection projectDependencies) {
        List identifiers = originalDependencies.getArtifacts().stream().map(x$0 -> OriginalArtifactIdentifier.of(x$0)).distinct().collect(Collectors.toList());
        Ordering ordering = Ordering.explicit(identifiers);
        return Stream.concat(externalDependencies.getArtifacts().stream(), projectDependencies.getArtifacts().stream()).map(ClassPathTransformedArtifact::ofTransformedArtifact).sorted((first, second) -> ordering.compare((Object)((ClassPathTransformedArtifact)first).originalIdentifier, (Object)((ClassPathTransformedArtifact)second).originalIdentifier)).map(artifact -> ((ClassPathTransformedArtifact)artifact).file).collect(Collectors.toList());
    }

    private static class OriginalArtifactIdentifier {
        private final String originalFileName;
        private final ComponentIdentifier componentIdentifier;

        private OriginalArtifactIdentifier(String originalFileName, ComponentIdentifier componentIdentifier) {
            this.originalFileName = originalFileName;
            this.componentIdentifier = componentIdentifier;
        }

        private static OriginalArtifactIdentifier of(ResolvedArtifactResult artifact) {
            if (artifact.getId() instanceof TransformedComponentFileArtifactIdentifier) {
                TransformedComponentFileArtifactIdentifier identifier = (TransformedComponentFileArtifactIdentifier)artifact.getId();
                return new OriginalArtifactIdentifier(identifier.getOriginalFileName(), identifier.getComponentIdentifier());
            }
            return new OriginalArtifactIdentifier(artifact.getFile().getName(), artifact.getId().getComponentIdentifier());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OriginalArtifactIdentifier that = (OriginalArtifactIdentifier)o;
            return Objects.equals(this.originalFileName, that.originalFileName) && Objects.equals(this.componentIdentifier, that.componentIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.originalFileName, this.componentIdentifier);
        }

        public String toString() {
            return "OriginalArtifactIdentifier{originalFileName='" + this.originalFileName + '\'' + ", componentIdentifier=" + this.componentIdentifier + '}';
        }
    }

    private static class ClassPathTransformedArtifact {
        private final File file;
        private final OriginalArtifactIdentifier originalIdentifier;

        private ClassPathTransformedArtifact(File file, OriginalArtifactIdentifier originalIdentifier) {
            this.file = file;
            this.originalIdentifier = originalIdentifier;
        }

        public static ClassPathTransformedArtifact ofTransformedArtifact(ResolvedArtifactResult transformedArtifact) {
            Preconditions.checkArgument((boolean)(transformedArtifact.getId() instanceof TransformedComponentFileArtifactIdentifier));
            return new ClassPathTransformedArtifact(transformedArtifact.getFile(), OriginalArtifactIdentifier.of(transformedArtifact));
        }

        public String toString() {
            return "ClassPathTransformedArtifact{file=" + this.file + ", originalIdentifier=" + this.originalIdentifier + '}';
        }
    }
}

