/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.initialization.BuildLayoutParametersBuildOptions;
import org.gradle.initialization.ParallelismBuildOptions;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.launcher.cli.converter.WelcomeMessageBuildOptions;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.launcher.daemon.toolchain.ToolchainBuildOptions;
import org.gradle.util.internal.CollectionUtils;

public class LayoutToPropertiesConverter {
    private final List<BuildOption<?>> allBuildOptions = new ArrayList();
    private final BuildLayoutFactory buildLayoutFactory;

    public LayoutToPropertiesConverter(BuildLayoutFactory buildLayoutFactory) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.allBuildOptions.addAll(new BuildLayoutParametersBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new StartParameterBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new LoggingConfigurationBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new WelcomeMessageBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new DaemonBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new ParallelismBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new ToolchainBuildOptions().getAllOptions());
    }

    public AllProperties convert(InitialProperties initialProperties, BuildLayoutResult layout) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.configureFromHomeDir(layout.getGradleInstallationHomeDir(), properties);
        this.configureFromBuildDir(layout, properties);
        this.configureFromHomeDir(layout.getGradleUserHomeDir(), properties);
        this.configureFromSystemPropertiesOfThisJvm((Map)Cast.uncheckedNonnullCast(properties));
        properties.putAll(initialProperties.getRequestedSystemProperties());
        HashMap<String, String> daemonJvmProperties = new HashMap<String, String>();
        this.configureFromDaemonJVMProperties(layout, daemonJvmProperties);
        return new Result(properties, daemonJvmProperties, initialProperties);
    }

    private void configureFromSystemPropertiesOfThisJvm(Map<Object, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Serializable) || !(value instanceof Serializable) && value != null) continue;
            properties.put(key, value);
        }
    }

    private void configureFromHomeDir(File gradleUserHomeDir, Map<String, String> result) {
        this.maybeConfigureFrom(new File(gradleUserHomeDir, "gradle.properties"), result);
    }

    private void configureFromBuildDir(BuildLayoutResult layoutResult, Map<String, String> result) {
        BuildLayout layout = this.buildLayoutFactory.getLayoutFor(layoutResult.toLayoutConfiguration());
        this.maybeConfigureFrom(new File(layout.getRootDirectory(), "gradle.properties"), result);
    }

    private void configureFromDaemonJVMProperties(BuildLayoutResult layoutResult, Map<String, String> result) {
        BuildLayout layout = this.buildLayoutFactory.getLayoutFor(layoutResult.toLayoutConfiguration());
        this.configureFrom(new File(layout.getRootDirectory(), "gradle/gradle-daemon-jvm.properties"), result);
    }

    private void configureFrom(File propertiesFile, Map<String, String> result) {
        Properties properties = LayoutToPropertiesConverter.readProperties(propertiesFile);
        for (Object key : properties.keySet()) {
            result.put(key.toString(), properties.get(key).toString());
        }
    }

    private void maybeConfigureFrom(File propertiesFile, Map<String, String> result) {
        Properties properties = LayoutToPropertiesConverter.readProperties(propertiesFile);
        for (Object key : properties.keySet()) {
            String keyAsString = key.toString();
            BuildOption validOption = (BuildOption)CollectionUtils.findFirst(this.allBuildOptions, option -> keyAsString.equals(option.getProperty()) || keyAsString.equals(option.getDeprecatedProperty()));
            if (validOption == null) continue;
            result.put(key.toString(), properties.get(key).toString());
        }
    }

    private static Properties readProperties(File propertiesFile) {
        Properties properties = new Properties();
        if (propertiesFile.isFile()) {
            try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
                properties.load(inputStream);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return properties;
    }

    private static class Result
    implements AllProperties {
        private final Map<String, String> properties;
        private final Map<String, String> daemonJvmProperties;
        private final InitialProperties initialProperties;

        public Result(Map<String, String> properties, Map<String, String> daemonJvmProperties, InitialProperties initialProperties) {
            this.properties = properties;
            this.daemonJvmProperties = daemonJvmProperties;
            this.initialProperties = initialProperties;
        }

        public Map<String, String> getRequestedSystemProperties() {
            return this.initialProperties.getRequestedSystemProperties();
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public Map<String, String> getDaemonJvmProperties() {
            return Collections.unmodifiableMap(this.daemonJvmProperties);
        }

        public Result merge(Map<String, String> systemProperties) {
            HashMap<String, String> properties = new HashMap<String, String>(this.properties);
            properties.putAll(systemProperties);
            properties.putAll(this.initialProperties.getRequestedSystemProperties());
            return new Result(properties, this.daemonJvmProperties, this.initialProperties);
        }
    }
}

