/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class JacocoReportBase
extends JacocoBase {
    public JacocoReportBase() {
        this.onlyIf("Any of the execution data files exists", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return Iterables.any((Iterable)JacocoReportBase.this.getExecutionData(), (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        return file.exists();
                    }
                });
            }
        });
    }

    @Inject
    protected abstract Instantiator getInstantiator();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    public abstract ConfigurableFileCollection getExecutionData();

    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public abstract ConfigurableFileCollection getSourceDirectories();

    @Classpath
    public abstract ConfigurableFileCollection getClassDirectories();

    @Optional
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public abstract ConfigurableFileCollection getAdditionalClassDirs();

    @Optional
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public abstract ConfigurableFileCollection getAdditionalSourceDirs();

    @Incubating
    @Optional
    @Input
    public abstract Property<String> getSourceEncoding();

    public void executionData(Object ... files) {
        this.getExecutionData().from(files);
    }

    public void executionData(Task ... tasks) {
        for (Task task : tasks) {
            final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().findByType(JacocoTaskExtension.class);
            if (extension == null) continue;
            this.executionData(new Callable<File>(){

                @Override
                public File call() {
                    return extension.getDestinationFile();
                }
            });
            this.mustRunAfter(new Object[]{task});
        }
    }

    public void executionData(TaskCollection tasks) {
        tasks.all(xva$0 -> this.executionData((Task)xva$0));
    }

    @Internal
    @NotToBeReplacedByLazyProperty(because="Not settable FileCollection", willBeDeprecated=true)
    public FileCollection getAllClassDirs() {
        return this.getClassDirectories().plus((FileCollection)this.getAdditionalClassDirs());
    }

    @Internal
    @NotToBeReplacedByLazyProperty(because="Not settable FileCollection", willBeDeprecated=true)
    public FileCollection getAllSourceDirs() {
        return this.getSourceDirectories().plus((FileCollection)this.getAdditionalSourceDirs());
    }

    public void sourceSets(SourceSet ... sourceSets) {
        for (final SourceSet sourceSet : sourceSets) {
            this.getSourceDirectories().from(new Object[]{new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return sourceSet.getAllJava().getSrcDirs();
                }
            }});
            this.getClassDirectories().from(new Object[]{sourceSet.getOutput()});
        }
    }

    public void additionalClassDirs(File ... dirs) {
        this.additionalClassDirs((FileCollection)this.getObjectFactory().fileCollection().from(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalClassDirs(FileCollection dirs) {
        this.getAdditionalClassDirs().from(new Object[]{dirs});
    }

    public void additionalSourceDirs(File ... dirs) {
        this.additionalSourceDirs((FileCollection)this.getObjectFactory().fileCollection().from(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalSourceDirs(FileCollection dirs) {
        this.getAdditionalSourceDirs().from(new Object[]{dirs});
    }
}

