/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.context;

import grails.util.Environment;
import grails.util.GrailsUtil;
import grails.util.Metadata;
import groovy.grape.Grape;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.security.AccessControlException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.web.context.GrailsConfigUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsContextLoader
extends ContextLoader {
    public static final Log LOG = LogFactory.getLog(GrailsContextLoader.class);
    GrailsApplication application;

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        WebApplicationContext ctx;
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        ExpandoMetaClass.enableGlobally();
        Metadata metadata = Metadata.getCurrent();
        if (metadata != null && metadata.isWarDeployed()) {
            Grape.setEnableAutoDownload((boolean)false);
            Grape.setEnableGrapes((boolean)false);
            Environment.cacheCurrentEnvironment();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"[GrailsContextLoader] Loading context. Creating parent application context");
        }
        try {
            ctx = super.initWebApplicationContext(servletContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[GrailsContextLoader] Created parent application context");
            }
            this.application = (GrailsApplication)ctx.getBean("grailsApplication", GrailsApplication.class);
            final WebApplicationContext finalCtx = ctx;
            ShutdownOperations.addOperation((Runnable)new Runnable(){

                public void run() {
                    ClassLoader classLoader;
                    if (GrailsContextLoader.this.application != null && (classLoader = GrailsContextLoader.this.application.getClassLoader()) instanceof GroovyClassLoader) {
                        Class[] loadedClasses;
                        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
                        for (Class loadedClass : loadedClasses = ((GroovyClassLoader)classLoader).getLoadedClasses()) {
                            metaClassRegistry.removeMetaClass(loadedClass);
                        }
                    }
                    GrailsPluginManager pluginManager = null;
                    if (finalCtx.containsBean("pluginManager")) {
                        pluginManager = (GrailsPluginManager)finalCtx.getBean("pluginManager", GrailsPluginManager.class);
                    }
                    if (pluginManager != null) {
                        try {
                            pluginManager.shutdown();
                        }
                        catch (Exception e) {
                            new DefaultStackTraceFilterer().filter((Throwable)e);
                            LOG.error((Object)("Error occurred shutting down plug-in manager: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            });
            ctx = GrailsConfigUtils.configureWebApplicationContext(servletContext, ctx);
            GrailsConfigUtils.executeGrailsBootstraps(this.application, ctx, servletContext);
        }
        catch (Throwable e) {
            GrailsUtil.deepSanitize((Throwable)e);
            LOG.error((Object)("Error initializing the application: " + e.getMessage()), e);
            if (Environment.isDevelopmentMode() && !Environment.isWarDeployed() && System.getProperty("grails.disable.exit") == null) {
                System.exit(1);
            }
            LOG.error((Object)("Error initializing Grails: " + e.getMessage()), e);
            if (e instanceof BeansException) {
                throw (BeansException)e;
            }
            throw new BootstrapException("Error executing bootstraps", e);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWebApplicationContext(ServletContext servletContext) {
        if (this.application == null || !this.application.isWarDeployed()) {
            return;
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        ConfigurableApplicationContext parent = ctx != null ? (ConfigurableApplicationContext)ctx.getParent() : null;
        try {
            ShutdownOperations.runOperations();
        }
        finally {
            super.closeWebApplicationContext(servletContext);
        }
        if (parent != null) {
            LOG.info((Object)("Destroying Spring parent WebApplicationContext " + parent.getDisplayName()));
            parent.close();
        }
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        this.application = null;
    }
}

