/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.log4j.appenders;

import grails.build.logging.GrailsConsole;
import groovy.util.ConfigObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.codehaus.groovy.grails.cli.logging.GrailsConsolePrintStream;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.codehaus.groovy.grails.exceptions.DefaultStackTracePrinter;
import org.codehaus.groovy.grails.exceptions.StackTraceFilterer;
import org.codehaus.groovy.grails.exceptions.StackTracePrinter;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;

public class GrailsConsoleAppender
extends AppenderSkeleton {
    public static final String MESSAGE_PREFIX = "Message: ";
    GrailsConsole console = GrailsConsole.getInstance();
    private StackTracePrinter stackTracePrinter;
    private StackTraceFilterer stackTraceFilterer;

    public GrailsConsoleAppender(ConfigObject config) {
        this.createStackTracePrinter(config);
        this.createStackTraceFilterer(config);
    }

    protected void append(LoggingEvent event) {
        Level level = event.getLevel();
        String message = this.buildMessage(event);
        if (System.out instanceof GrailsConsolePrintStream) {
            if (level.equals((Object)Level.ERROR) || level.equals((Object)Level.FATAL)) {
                this.console.error(message);
            } else {
                this.console.log(message);
            }
        } else if (level.equals((Object)Level.ERROR) || level.equals((Object)Level.FATAL)) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    private String buildMessage(LoggingEvent event) {
        StringBuilder b = new StringBuilder(this.layout.format(event));
        if (this.console.isVerbose()) {
            String[] throwableStrRep = event.getThrowableStrRep();
            if (throwableStrRep != null) {
                b.append(Layout.LINE_SEP);
                for (String line : throwableStrRep) {
                    b.append(line).append(Layout.LINE_SEP);
                }
            }
        } else {
            Throwable throwable;
            ThrowableInformation throwableInformation = event.getThrowableInformation();
            if (throwableInformation != null && (throwable = throwableInformation.getThrowable()) != null) {
                b.append(MESSAGE_PREFIX).append(throwable.getMessage()).append(Layout.LINE_SEP);
                this.stackTraceFilterer.filter(throwable, true);
                b.append(this.stackTracePrinter.prettyPrint(throwable));
            }
        }
        return b.toString();
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void createStackTracePrinter(ConfigObject config) {
        try {
            this.stackTracePrinter = (StackTracePrinter)GrailsResourceUtils.instantiateFromConfig((ConfigObject)config, (String)"grails.logging.stackTracePrinterClass", (String)DefaultStackTracePrinter.class.getName());
        }
        catch (Throwable t) {
            LogLog.warn((String)("Problem instantiating StackTracePrinter class, using default: " + t.getMessage()));
            try {
                this.stackTracePrinter = new DefaultStackTracePrinter();
            }
            catch (Throwable t1) {
                this.stackTracePrinter = new StackTracePrinter(){

                    public String prettyPrint(Throwable throwable) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        throwable.printStackTrace(pw);
                        return sw.toString();
                    }
                };
            }
        }
    }

    protected void createStackTraceFilterer(ConfigObject config) {
        try {
            this.stackTraceFilterer = (StackTraceFilterer)GrailsResourceUtils.instantiateFromConfig((ConfigObject)config, (String)"grails.logging.stackTraceFiltererClass", (String)DefaultStackTraceFilterer.class.getName());
        }
        catch (Throwable t) {
            LogLog.error((String)("Problem instantiating StackTraceFilter class, using default: " + t.getMessage()));
            this.stackTraceFilterer = new DefaultStackTraceFilterer();
        }
    }
}

