/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.springframework.uaa.client.UaaDetectedProducts;
import org.springframework.uaa.client.protobuf.UaaClient;
import org.springframework.uaa.client.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VersionHelper {
    private static final String javaRuntime = System.getProperty("java.runtime.name");
    private static final String javaVendor = System.getProperty("java.vendor");
    private static final String javaVersion = System.getProperty("java.runtime.version");
    private static final String osName = System.getProperty("os.name");
    private static final String osArch = System.getProperty("os.arch");
    private static final String osVersion = System.getProperty("os.version");

    public static String getProductStamp(UaaClient.Product uaa) {
        String source = "";
        String id = uaa.getSourceControlIdentifier();
        if (id != null && !"".equals(id)) {
            if (id.length() > 7) {
                id = id.substring(0, 7);
            }
            source = "[rev " + id + "]";
        }
        return uaa.getName() + " " + uaa.getMajorVersion() + "." + uaa.getMinorVersion() + "." + uaa.getPatchVersion() + "." + uaa.getReleaseQualifier() + " " + source;
    }

    public static UaaClient.Product getJvm() {
        UaaClient.Product.Builder b = VersionHelper.getProductBuilder(javaVersion);
        b.setName(javaVendor + " " + javaRuntime);
        return b.build();
    }

    public static UaaClient.Product getOs() {
        UaaClient.Product.Builder b = VersionHelper.getProductBuilder(osVersion);
        b.setName(osName + " " + osArch);
        return b.build();
    }

    public static UaaClient.Product getUaa() {
        try {
            return VersionHelper.getProductFromManifest(VersionHelper.class, UaaDetectedProducts.SPRING_UAA.getProductName());
        }
        catch (Exception e) {
            return VersionHelper.getProduct(UaaDetectedProducts.SPRING_UAA.getProductName(), "0.0.0.MILESTONE");
        }
    }

    static UaaClient.Product.Builder getProductBuilder(String versionString) {
        UaaClient.Product.Builder b = UaaClient.Product.newBuilder();
        GetNumbersResult getNumbersResult = VersionHelper.getNumbers(versionString, 3);
        if (getNumbersResult.numbers.size() >= 1) {
            b.setMajorVersion(getNumbersResult.numbers.get(0));
        }
        if (getNumbersResult.numbers.size() >= 2) {
            b.setMinorVersion(getNumbersResult.numbers.get(1));
        }
        if (getNumbersResult.numbers.size() >= 3) {
            b.setPatchVersion(getNumbersResult.numbers.get(2));
        }
        b.setReleaseQualifier(getNumbersResult.restOfString);
        return b;
    }

    static UaaClient.FeatureUse.Builder getFeatureUseBuilder(String versionString) {
        UaaClient.FeatureUse.Builder b = UaaClient.FeatureUse.newBuilder();
        if (versionString != null) {
            GetNumbersResult getNumbersResult = VersionHelper.getNumbers(versionString, 3);
            if (getNumbersResult.numbers.size() >= 1) {
                b.setMajorVersion(getNumbersResult.numbers.get(0));
            }
            if (getNumbersResult.numbers.size() >= 2) {
                b.setMinorVersion(getNumbersResult.numbers.get(1));
            }
            if (getNumbersResult.numbers.size() >= 3) {
                b.setPatchVersion(getNumbersResult.numbers.get(2));
            }
            b.setReleaseQualifier(getNumbersResult.restOfString);
        }
        return b;
    }

    public static UaaClient.FeatureUse getFeatureUse(String featureName) {
        return VersionHelper.getFeatureUse(featureName, null, null);
    }

    public static UaaClient.FeatureUse getFeatureUse(String featureName, String simpleVersionSequence) {
        return VersionHelper.getFeatureUse(featureName, simpleVersionSequence, null);
    }

    public static UaaClient.FeatureUse getFeatureUse(String featureName, String simpleVersionSequence, String sourceId) {
        Assert.hasLength(featureName, "Feature name required");
        UaaClient.FeatureUse.Builder b = VersionHelper.getFeatureUseBuilder(simpleVersionSequence);
        b.setName(featureName);
        if (sourceId != null && sourceId.length() > 0) {
            b.setSourceControlIdentifier(sourceId);
        }
        return b.build();
    }

    public static UaaClient.Product getProduct(String productName, String simpleVersionSequence) {
        return VersionHelper.getProduct(productName, simpleVersionSequence, null);
    }

    public static UaaClient.Product getProduct(String productName, String simpleVersionSequence, String sourceId) {
        Assert.hasLength(productName, "Product name required");
        Assert.hasLength(simpleVersionSequence, "Simple version sequence required");
        UaaClient.Product.Builder b = VersionHelper.getProductBuilder(simpleVersionSequence);
        b.setName(productName);
        if (sourceId != null && sourceId.length() > 0) {
            b.setSourceControlIdentifier(sourceId);
        }
        return b.build();
    }

    public static UaaClient.Product getProductFromManifest(Class<?> clazz, String productName) {
        try {
            String classContainer = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            if (classContainer.endsWith(".jar")) {
                URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(manifestUrl.openStream());
                return VersionHelper.getProductFromManifest(manifest, productName);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException("Unable to load manifest for class '" + clazz.getName() + "'");
    }

    public static UaaClient.Product getProductFromManifest(Manifest manifest, String productName) {
        String bundleVersion = null;
        String gitCommitHash = null;
        bundleVersion = manifest.getMainAttributes().getValue("Bundle-Version");
        Assert.notNull(bundleVersion, "Manifest does not contain a 'Bundle-Version' value");
        gitCommitHash = manifest.getMainAttributes().getValue("Git-Commit-Hash");
        return VersionHelper.getProduct(productName, bundleVersion, gitCommitHash);
    }

    public static GetNumbersResult getNumbers(String input, int maximumDesired) {
        GetNumbersResult result = new GetNumbersResult();
        result.numbers = new ArrayList<Integer>();
        StringBuilder currentNumber = new StringBuilder();
        char[] characters = input.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (Character.isDigit(characters[i])) {
                currentNumber.append(characters[i]);
                continue;
            }
            if (currentNumber.length() > 0) {
                try {
                    VersionHelper.addIfPossible(currentNumber, result.numbers);
                    currentNumber = new StringBuilder();
                }
                catch (NumberFormatException shouldNotHappen) {
                    // empty catch block
                }
            }
            if (result.numbers.size() != maximumDesired || characters.length <= i + 1) continue;
            StringBuilder rest = new StringBuilder();
            for (int x = i + 1; x < characters.length; ++x) {
                rest.append(characters[x]);
            }
            result.restOfString = rest.toString();
            return result;
        }
        if (currentNumber.length() > 0) {
            VersionHelper.addIfPossible(currentNumber, result.numbers);
        }
        return result;
    }

    private static void addIfPossible(StringBuilder input, List<Integer> list) {
        try {
            Integer i = new Integer(input.toString());
            list.add(i);
        }
        catch (NumberFormatException shouldNotHappen) {
            list.add(Integer.MAX_VALUE);
        }
    }

    static class GetNumbersResult {
        List<Integer> numbers;
        String restOfString = "";

        GetNumbersResult() {
        }
    }
}

