/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded.agent;

import com.springsource.loaded.FileChangeListener;
import com.springsource.loaded.GlobalConfiguration;
import com.springsource.loaded.ReloadableType;
import com.springsource.loaded.TypeRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReloadableFileChangeListener
implements FileChangeListener {
    private static Logger log = Logger.getLogger(ReloadableFileChangeListener.class.getName());
    private TypeRegistry typeRegistry;
    private Map<File, ReloadableType> correspondingReloadableTypes = new HashMap<File, ReloadableType>();

    public ReloadableFileChangeListener(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void fileChanged(File file) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("ReloadableFileChangeListener: change detected in " + file);
        }
        ReloadableType rtype = this.correspondingReloadableTypes.get(file);
        this.typeRegistry.loadNewVersion(rtype, file);
    }

    public void register(ReloadableType rtype, File file) {
        this.correspondingReloadableTypes.put(file, rtype);
    }
}

