/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.mime.MimeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMimeUtility
implements MimeUtility {
    private List<MimeType> mimeTypes;
    private Map<String, MimeType> extensionToMimeMap = new HashMap<String, MimeType>();

    public DefaultMimeUtility(MimeType[] mimeTypes) {
        this(Arrays.asList(mimeTypes));
    }

    public DefaultMimeUtility(List<MimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
        for (MimeType mimeType : mimeTypes) {
            String ext = mimeType.getExtension();
            if (this.extensionToMimeMap.containsKey(ext)) continue;
            this.extensionToMimeMap.put(ext, mimeType);
        }
    }

    @Override
    public List<MimeType> getKnownMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public MimeType getMimeTypeForExtension(String extension) {
        if (extension == null) {
            return null;
        }
        return this.extensionToMimeMap.get(extension);
    }

    @Override
    public MimeType getMimeTypeForURI(String uri) {
        if (uri == null) {
            return null;
        }
        int i = uri.lastIndexOf(46);
        int length = uri.length();
        if (i > -1 && i < length) {
            String extension = uri.substring(i + 1, length);
            return this.getMimeTypeForExtension(extension);
        }
        return null;
    }
}

