/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.uaa.client.UaaDetectedProducts;
import org.springframework.uaa.client.util.Base64;
import org.springframework.uaa.client.util.PreferencesUtils;
import org.springframework.uaa.client.util.StreamUtils;
import org.springframework.uaa.client.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UaaDetectedProductsImpl
implements UaaDetectedProducts {
    private static final String DETECTED_PRODUCTS_KEY = "detected_products";
    private static final String EMPTY_STRING = "";
    private static final byte[] EMPTY = new byte[0];
    private static final Preferences P = PreferencesUtils.getPreferencesFor(UaaDetectedProductsImpl.class);
    private static final List<UaaDetectedProducts.ProductInfo> products = new ArrayList<UaaDetectedProducts.ProductInfo>();
    private static int version = 0;

    @Override
    public UaaDetectedProducts.ProductInfo getDetectedProductInfo(String groupId, String artifactId) {
        if (groupId != null && artifactId != null) {
            for (UaaDetectedProducts.ProductInfo productInfo : this.getDetectedProductInfos()) {
                if (!productInfo.getGroupId().equals(groupId) || !productInfo.getArtifactId().equals(artifactId)) continue;
                return productInfo;
            }
        }
        return null;
    }

    @Override
    public List<UaaDetectedProducts.ProductInfo> getDetectedProductInfos() {
        UaaDetectedProductsImpl.initializeIfRequired();
        return Collections.unmodifiableList(products);
    }

    @Override
    public boolean shouldReportUsage(String groupId, String artifactId) {
        return this.getDetectedProductInfo(groupId, artifactId) != null;
    }

    public static final int getVersion() {
        UaaDetectedProductsImpl.initializeIfRequired();
        return version;
    }

    static boolean setProducts(InputStream inputXmlDocument) {
        if (inputXmlDocument == null) {
            return false;
        }
        try {
            int incomingVersion;
            int existingVersion;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtils.copy(inputXmlDocument, baos);
            byte[] incoming = baos.toByteArray();
            if (incoming.length == 0) {
                return false;
            }
            byte[] existing = Base64.decode(P.get(DETECTED_PRODUCTS_KEY, EMPTY_STRING));
            if (existing != EMPTY && existing.length > 0 && (existingVersion = UaaDetectedProductsImpl.getVersion(existing)) >= (incomingVersion = UaaDetectedProductsImpl.getVersion(incoming))) {
                incoming = existing;
            }
            version = UaaDetectedProductsImpl.getVersion(incoming);
            Document d = XmlUtils.parse(new ByteArrayInputStream(incoming));
            Element docElement = d.getDocumentElement();
            NodeList nodeList = docElement.getElementsByTagName("product");
            products.clear();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (!(n instanceof Element)) continue;
                Element product = (Element)n;
                String productName = product.getAttribute("name");
                String groupId = product.getAttribute("group-id");
                String artifactId = product.getAttribute("artifact-id");
                String typeName = product.getAttribute("type-name");
                if (productName.length() <= 0 || groupId.length() <= 0 || artifactId.length() <= 0) continue;
                products.add(new UaaDetectedProducts.ProductInfo(productName, groupId, artifactId, typeName));
            }
            if (incoming != existing) {
                String base64 = Base64.encodeBytes(incoming, 2);
                P.put(DETECTED_PRODUCTS_KEY, base64);
                return true;
            }
            return false;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static int getVersion(byte[] document) throws ParserConfigurationException, IOException, SAXException {
        Document d = XmlUtils.parse(new ByteArrayInputStream(document));
        Element docElement = d.getDocumentElement();
        String ver = docElement.getAttribute("version");
        return new Integer(ver);
    }

    private static void initializeIfRequired() {
        if (products.size() == 0 || version == 0) {
            InputStream defaults = UaaDetectedProductsImpl.getDetectedProductsFromClassLoader();
            UaaDetectedProductsImpl.setProducts(defaults);
        }
    }

    static void clearAllKeys() {
        try {
            P.clear();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    static InputStream getDetectedProductsFromClassLoader() {
        return UaaDetectedProductsImpl.class.getResourceAsStream("/org/springframework/uaa/client/uaa-client.xml");
    }

    static int getPreferencesKeyCount() {
        try {
            return P.keys().length;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    static void resetProducts() {
        P.remove(DETECTED_PRODUCTS_KEY);
        InputStream defaults = UaaDetectedProductsImpl.class.getResourceAsStream("/org/springframework/uaa/client/uaa-client.xml");
        UaaDetectedProductsImpl.setProducts(defaults);
    }
}

