/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class TypeDescriptorExtractor {
    private TypeRegistry registry;

    public TypeDescriptorExtractor(TypeRegistry registry) {
        this.registry = registry;
    }

    public TypeDescriptor extract(byte[] bytes, boolean isReloadableType) {
        ClassReader fileReader = new ClassReader(bytes);
        ExtractionVisitor extractionVisitor = new ExtractionVisitor(isReloadableType);
        fileReader.accept(extractionVisitor, 0);
        return extractionVisitor.getTypeDescriptor();
    }

    class ExtractionVisitor
    implements ClassVisitor,
    Opcodes {
        private boolean isReloadableType;
        private int flags;
        private String typename;
        private String superclassName;
        private String[] interfaceNames;
        private boolean isGroovy = false;
        private boolean hasClinit = false;
        private List<MethodMember> constructors = new ArrayList<MethodMember>();
        private List<MethodMember> methods = new ArrayList<MethodMember>();
        private List<FieldMember> fieldsRequiringAccessors = new ArrayList<FieldMember>();
        private List<FieldMember> fields = new ArrayList<FieldMember>();
        private List<String> finalInHierarchy = new ArrayList<String>();

        public ExtractionVisitor(boolean isReloadableType) {
            this.isReloadableType = isReloadableType;
        }

        public TypeDescriptor getTypeDescriptor() {
            if (this.isReloadableType) {
                this.computeCatchers();
            }
            this.computeFieldsRequiringAccessors();
            this.computeClashes();
            TypeDescriptor td = new TypeDescriptor(this.typename, this.superclassName, this.interfaceNames, this.flags, this.constructors, this.methods, this.fields, this.fieldsRequiringAccessors, this.isReloadableType, TypeDescriptorExtractor.this.registry, this.hasClinit, this.finalInHierarchy);
            if (this.isGroovy) {
                td.setIsGroovyType(true);
            }
            return td;
        }

        private void computeClashes() {
            String clashDescriptorPrefix = "(L" + this.typename + ";";
            for (MethodMember member : this.methods) {
                String desc;
                if (!member.isStatic() || !(desc = member.descriptor).startsWith(clashDescriptorPrefix)) continue;
                for (MethodMember member2 : this.methods) {
                    String staticParams;
                    if (!member2.name.equals(member.name)) continue;
                    String instanceParams = member2.descriptor;
                    if (!(instanceParams = instanceParams.substring(1, instanceParams.indexOf(41) + 1)).equals(staticParams = desc.substring(clashDescriptorPrefix.length(), desc.indexOf(41) + 1))) continue;
                    member.bits |= 2;
                }
            }
        }

        private TypeDescriptor getTypeDescriptorFor(String slashedname) {
            return TypeDescriptorExtractor.this.registry.getDescriptorFor(slashedname);
        }

        private TypeDescriptor findTypeDescriptor(TypeRegistry registry, String typename) {
            TypeRegistry regToTry = registry;
            TypeDescriptor td = regToTry.getDescriptorForReloadableType(typename);
            while (td == null) {
                if ((regToTry = regToTry.getParentRegistry()) == null) break;
                td = regToTry.getDescriptorForReloadableType(typename);
            }
            if (td == null) {
                td = this.getTypeDescriptorFor(typename);
            }
            return td;
        }

        /*
         * Unable to fully structure code
         */
        private void computeCatchers() {
            shouldNotCatch = new ArrayList<String>();
            type = this.superclassName;
            if (!Modifier.isInterface(this.flags)) ** GOTO lbl28
            return;
lbl-1000:
            // 1 sources

            {
                supertypeDescriptor = this.findTypeDescriptor(TypeDescriptorExtractor.access$0(TypeDescriptorExtractor.this), type);
                var4_4 = supertypeDescriptor.getMethods();
                var5_5 = var4_4.length;
                var6_7 = 0;
                while (var6_7 < var5_5) {
                    method = var4_4[var6_7];
                    if (this.shouldCatchMethod(method) && !shouldNotCatch.contains(method.getNameAndDescriptor())) {
                        found = null;
                        for (MethodMember existingMethod : this.methods) {
                            if (!existingMethod.equalsApartFromModifiers(method)) continue;
                            found = existingMethod;
                            break;
                        }
                        if (found == null) {
                            catcherCopy = method.catcherCopyOf();
                            this.methods.add(catcherCopy);
                        }
                    } else if (method.isFinal()) {
                        shouldNotCatch.add(method.getNameAndDescriptor());
                    }
                    ++var6_7;
                }
                type = supertypeDescriptor.supertypeName;
lbl28:
                // 2 sources

                ** while (type != null)
            }
lbl29:
            // 1 sources

            if (Modifier.isAbstract(this.flags)) {
                var5_6 = this.interfaceNames;
                var6_7 = this.interfaceNames.length;
                var7_9 = 0;
                while (var7_9 < var6_7) {
                    interfaceName = var5_6[var7_9];
                    this.addCatchersForNonImplementedMethodsFrom(interfaceName);
                    ++var7_9;
                }
            }
            this.finalInHierarchy.addAll(shouldNotCatch);
        }

        private void addCatchersForNonImplementedMethodsFrom(String interfacename) {
            TypeDescriptor interfaceDescriptor = this.findTypeDescriptor(TypeDescriptorExtractor.this.registry, interfacename);
            Object[] objectArray = interfaceDescriptor.getMethods();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodMember method = objectArray[n2];
                boolean found = false;
                for (MethodMember existingMethod : this.methods) {
                    if (!existingMethod.equalsApartFromModifiers(method)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.methods.add(method.catcherCopyOfWithAbstractRemoved());
                }
                ++n2;
            }
            objectArray = interfaceDescriptor.superinterfaceNames;
            n = interfaceDescriptor.superinterfaceNames.length;
            n2 = 0;
            while (n2 < n) {
                Object interfaceName = objectArray[n2];
                this.addCatchersForNonImplementedMethodsFrom((String)interfaceName);
                ++n2;
            }
        }

        private void computeFieldsRequiringAccessors() {
            String type = this.superclassName;
            while (type != null) {
                TypeDescriptor supertypeDescriptor = this.findTypeDescriptor(TypeDescriptorExtractor.this.registry, type);
                if (!supertypeDescriptor.isReloadable()) {
                    FieldMember[] fieldMemberArray = supertypeDescriptor.getFields();
                    int n = fieldMemberArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FieldMember field = fieldMemberArray[n2];
                        if (field.isProtected()) {
                            boolean found = false;
                            for (FieldMember existingField : this.fields) {
                                if (!existingField.getName().equals(field.getName())) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                this.fieldsRequiringAccessors.add(field);
                            }
                        }
                        ++n2;
                    }
                }
                type = supertypeDescriptor.supertypeName;
            }
        }

        private boolean shouldCatchMethod(MethodMember method) {
            return !method.isPrivateStaticFinal() && (!method.getName().equals("finalize") || !method.getDescriptor().equals("()V"));
        }

        public void visit(int version, int flags, String name, String signature, String superclassName, String[] interfaceNames) {
            this.flags = flags;
            this.superclassName = superclassName;
            this.interfaceNames = interfaceNames;
            this.typename = name;
        }

        public AnnotationVisitor visitAnnotation(String classDesc, boolean isRuntime) {
            return null;
        }

        public void visitAttribute(Attribute arg0) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.fields.add(new FieldMember(this.typename, access, name, desc, signature));
            if (name.equals("$callSiteArray")) {
                this.isGroovy = true;
            }
            return null;
        }

        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String genericSignature, String[] exceptions) {
            if (name.charAt(0) != '<') {
                this.methods.add(new MethodMember(flags, name, descriptor, genericSignature, exceptions));
            } else if (name.equals("<init>")) {
                this.constructors.add(new MethodMember(flags, name, descriptor, genericSignature, exceptions));
            } else if (name.equals("<clinit>")) {
                this.hasClinit = true;
            }
            return null;
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitEnd() {
        }
    }
}

