/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.gorm.DetachedCriteria;
import grails.orm.RlikeExpression;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractStaticPersistentMethod;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.TypedValue;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClausedStaticPersistentMethod
extends AbstractStaticPersistentMethod {
    private static final Log LOG = LogFactory.getLog(AbstractClausedStaticPersistentMethod.class);
    private final String[] operators;
    private final Pattern[] operatorPatterns;

    public AbstractClausedStaticPersistentMethod(GrailsApplication application, SessionFactory sessionFactory, ClassLoader classLoader, Pattern pattern, String[] operators) {
        super(sessionFactory, classLoader, pattern, application);
        this.operators = operators;
        this.operatorPatterns = new Pattern[operators.length];
        for (int i = 0; i < operators.length; ++i) {
            this.operatorPatterns[i] = Pattern.compile("(\\w+)(" + operators[i] + ")(\\p{Upper})(\\w+)");
        }
    }

    @Override
    protected Object doInvokeInternal(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        return this.doInvokeInternal(clazz, methodName, null, additionalCriteria, arguments);
    }

    @Override
    protected Object doInvokeInternal(Class clazz, String methodName, DetachedCriteria additionalCriteria, Object[] arguments) {
        return this.doInvokeInternal(clazz, methodName, additionalCriteria, null, arguments);
    }

    protected Object doInvokeInternal(Class<?> clazz, String methodName, DetachedCriteria<?> detachedCriteria, Closure<?> additionalCriteria, Object[] arguments) {
        String querySequence;
        ArrayList<GrailsMethodExpression> expressions = new ArrayList<GrailsMethodExpression>();
        if (arguments == null) {
            arguments = new Object[]{};
        }
        Matcher match = super.getPattern().matcher(methodName);
        match.find();
        int totalRequiredArguments = 0;
        int groupCount = match.groupCount();
        if (groupCount == 6) {
            String booleanProperty = match.group(3);
            if (booleanProperty == null) {
                booleanProperty = match.group(6);
                querySequence = null;
            } else {
                querySequence = match.group(5);
            }
            Boolean arg = Boolean.TRUE;
            if (booleanProperty.matches("Not[A-Z].*")) {
                booleanProperty = booleanProperty.substring(3);
                arg = Boolean.FALSE;
            }
            GrailsMethodExpression booleanExpression = GrailsMethodExpression.create(this.application, clazz, booleanProperty);
            booleanExpression.setArguments(new Object[]{arg});
            expressions.add(booleanExpression);
        } else {
            querySequence = match.group(2);
        }
        boolean containsOperator = false;
        String operatorInUse = null;
        if (querySequence != null) {
            for (int i = 0; i < this.operators.length; ++i) {
                Matcher currentMatcher = this.operatorPatterns[i].matcher(querySequence);
                if (!currentMatcher.find()) continue;
                containsOperator = true;
                operatorInUse = this.operators[i];
                String[] queryParameters = querySequence.split(operatorInUse);
                int argumentCursor = 0;
                for (String queryParameter : queryParameters) {
                    GrailsMethodExpression currentExpression = GrailsMethodExpression.create(this.application, clazz, queryParameter);
                    totalRequiredArguments += currentExpression.argumentsRequired;
                    Object[] currentArguments = new Object[currentExpression.argumentsRequired];
                    if (argumentCursor + currentExpression.argumentsRequired > arguments.length) {
                        throw new MissingMethodException(methodName, clazz, arguments);
                    }
                    int k = 0;
                    while (k < currentExpression.argumentsRequired) {
                        currentArguments[k] = arguments[argumentCursor];
                        ++k;
                        ++argumentCursor;
                    }
                    try {
                        currentExpression.setArguments(currentArguments);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.debug((Object)iae.getMessage(), (Throwable)iae);
                        throw new MissingMethodException(methodName, clazz, arguments);
                    }
                    expressions.add(currentExpression);
                }
                break;
            }
        }
        if (!containsOperator && querySequence != null) {
            GrailsMethodExpression solo = GrailsMethodExpression.create(this.application, clazz, querySequence);
            if (solo.argumentsRequired > arguments.length) {
                throw new MissingMethodException(methodName, clazz, arguments);
            }
            totalRequiredArguments += solo.argumentsRequired;
            Object[] soloArgs = new Object[solo.argumentsRequired];
            System.arraycopy(arguments, 0, soloArgs, 0, solo.argumentsRequired);
            try {
                solo.setArguments(soloArgs);
            }
            catch (IllegalArgumentException iae) {
                LOG.debug((Object)iae.getMessage(), (Throwable)iae);
                throw new MissingMethodException(methodName, clazz, arguments);
            }
            expressions.add(solo);
        }
        if (totalRequiredArguments > arguments.length) {
            throw new MissingMethodException(methodName, clazz, arguments);
        }
        Object[] remainingArguments = new Object[arguments.length - totalRequiredArguments];
        if (remainingArguments.length > 0) {
            int i = 0;
            int j = totalRequiredArguments;
            while (i < remainingArguments.length) {
                remainingArguments[i] = arguments[j];
                ++i;
                ++j;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Calculated expressions: " + expressions));
        }
        return this.doInvokeInternalWithExpressions(clazz, methodName, remainingArguments, expressions, operatorInUse, detachedCriteria, additionalCriteria);
    }

    protected abstract Object doInvokeInternalWithExpressions(Class var1, String var2, Object[] var3, List var4, String var5, DetachedCriteria var6, Closure var7);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class GrailsMethodExpression {
        protected static final String LESS_THAN = "LessThan";
        protected static final String LESS_THAN_OR_EQUAL = "LessThanEquals";
        protected static final String GREATER_THAN = "GreaterThan";
        protected static final String GREATER_THAN_OR_EQUAL = "GreaterThanEquals";
        protected static final String LIKE = "Like";
        protected static final String ILIKE = "Ilike";
        protected static final String RLIKE = "Rlike";
        protected static final String BETWEEN = "Between";
        protected static final String IN_LIST = "InList";
        protected static final String IS_NOT_NULL = "IsNotNull";
        protected static final String IS_NULL = "IsNull";
        protected static final String NOT = "Not";
        protected static final String EQUAL = "Equal";
        protected static final String NOT_EQUAL = "NotEqual";
        protected String propertyName;
        protected Object[] arguments;
        protected int argumentsRequired;
        protected boolean negation;
        protected String type;
        protected Class<?> targetClass;
        private GrailsApplication application;
        static final Criterion FORCE_NO_RESULTS = new Criterion(){
            private static final long serialVersionUID = 1L;

            public TypedValue[] getTypedValues(Criteria c, CriteriaQuery q) {
                return null;
            }

            public String toSqlString(Criteria c, CriteriaQuery q) {
                return null;
            }
        };

        GrailsMethodExpression(GrailsApplication application, Class<?> targetClass, String propertyName, String type, int argumentsRequired, boolean negation) {
            this.application = application;
            this.targetClass = targetClass;
            this.propertyName = propertyName;
            this.type = type;
            this.argumentsRequired = argumentsRequired;
            this.negation = negation;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Object[] getArguments() {
            Object[] copy = new Object[this.arguments.length];
            System.arraycopy(this.arguments, 0, copy, 0, this.arguments.length);
            return copy;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("[GrailsMethodExpression] ");
            buf.append(this.propertyName).append(" ").append(this.type).append(" ");
            for (int i = 0; i < this.arguments.length; ++i) {
                buf.append(this.arguments[i]);
                if (i == this.arguments.length) continue;
                buf.append(" and ");
            }
            return buf.toString();
        }

        void setArguments(Object[] args) throws IllegalArgumentException {
            if (args.length != this.argumentsRequired) {
                throw new IllegalArgumentException("Method expression '" + this.type + "' requires " + this.argumentsRequired + " arguments");
            }
            GrailsDomainClass dc = (GrailsDomainClass)this.application.getArtefact("Domain", this.targetClass.getName());
            GrailsDomainClassProperty prop = dc.getPropertyByName(this.propertyName);
            if (prop == null) {
                throw new IllegalArgumentException("Property " + this.propertyName + " doesn't exist for method expression '" + this.type + "'");
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (prop.getType() == String.class && args[i] instanceof CharSequence) {
                    args[i] = args[i].toString();
                    continue;
                }
                if (prop.getType().isAssignableFrom(args[i].getClass()) || GrailsClassUtils.isMatchBetweenPrimativeAndWrapperTypes((Class)prop.getType(), args[i].getClass())) continue;
                SimpleTypeConverter converter = new SimpleTypeConverter();
                try {
                    if (this.type.equals(IN_LIST)) {
                        args[i] = converter.convertIfNecessary(args[i], Collection.class);
                        continue;
                    }
                    args[i] = converter.convertIfNecessary(args[i], prop.getType());
                    continue;
                }
                catch (TypeMismatchException tme) {
                    if (Number.class.isAssignableFrom(args[i].getClass())) {
                        try {
                            args[i] = converter.convertIfNecessary((Object)args[i].toString(), prop.getType());
                            continue;
                        }
                        catch (TypeMismatchException tme1) {
                            throw new IllegalArgumentException("Cannot convert value " + args[i] + " of property '" + this.propertyName + "' to required type " + prop.getType() + ": " + tme1.getMessage());
                        }
                    }
                    throw new IllegalArgumentException("Cannot convert value " + args[i] + " of property '" + this.propertyName + "' to required type " + prop.getType());
                }
            }
            this.arguments = args;
        }

        abstract Criterion createCriterion();

        protected Criterion getCriterion() {
            Assert.notNull((Object)this.arguments, (String)"Parameters array must be set before retrieving Criterion");
            return this.negation ? Restrictions.not((Criterion)this.createCriterion()) : this.createCriterion();
        }

        protected static GrailsMethodExpression create(GrailsApplication application, Class<?> clazz, String queryParameter) {
            if (queryParameter.endsWith(LESS_THAN_OR_EQUAL)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, LESS_THAN_OR_EQUAL), LESS_THAN_OR_EQUAL, 1, GrailsMethodExpression.isNegation(queryParameter, LESS_THAN_OR_EQUAL)){

                    Criterion createCriterion() {
                        return Restrictions.le((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(LESS_THAN)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, LESS_THAN), LESS_THAN, 1, GrailsMethodExpression.isNegation(queryParameter, LESS_THAN)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNull((String)this.propertyName);
                        }
                        return Restrictions.lt((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(GREATER_THAN_OR_EQUAL)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, GREATER_THAN_OR_EQUAL), GREATER_THAN_OR_EQUAL, 1, GrailsMethodExpression.isNegation(queryParameter, GREATER_THAN_OR_EQUAL)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNull((String)this.propertyName);
                        }
                        return Restrictions.ge((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(GREATER_THAN)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, GREATER_THAN), GREATER_THAN, 1, GrailsMethodExpression.isNegation(queryParameter, GREATER_THAN)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNull((String)this.propertyName);
                        }
                        return Restrictions.gt((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(LIKE)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, LIKE), LIKE, 1, GrailsMethodExpression.isNegation(queryParameter, LIKE)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNull((String)this.propertyName);
                        }
                        return Restrictions.like((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(ILIKE)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, ILIKE), ILIKE, 1, GrailsMethodExpression.isNegation(queryParameter, ILIKE)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNull((String)this.propertyName);
                        }
                        return Restrictions.ilike((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(RLIKE)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, RLIKE), RLIKE, 1, GrailsMethodExpression.isNegation(queryParameter, RLIKE)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNull((String)this.propertyName);
                        }
                        return new RlikeExpression(this.propertyName, this.arguments[0]);
                    }
                };
            }
            if (queryParameter.endsWith(IS_NOT_NULL)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, IS_NOT_NULL), IS_NOT_NULL, 0, GrailsMethodExpression.isNegation(queryParameter, IS_NOT_NULL)){

                    Criterion createCriterion() {
                        return Restrictions.isNotNull((String)this.propertyName);
                    }
                };
            }
            if (queryParameter.endsWith(IS_NULL)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, IS_NULL), IS_NULL, 0, GrailsMethodExpression.isNegation(queryParameter, IS_NULL)){

                    Criterion createCriterion() {
                        return Restrictions.isNull((String)this.propertyName);
                    }
                };
            }
            if (queryParameter.endsWith(BETWEEN)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, BETWEEN), BETWEEN, 2, GrailsMethodExpression.isNegation(queryParameter, BETWEEN)){

                    Criterion createCriterion() {
                        return Restrictions.between((String)this.propertyName, (Object)this.arguments[0], (Object)this.arguments[1]);
                    }
                };
            }
            if (queryParameter.endsWith(IN_LIST)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, IN_LIST), IN_LIST, 1, GrailsMethodExpression.isNegation(queryParameter, IN_LIST)){

                    Criterion createCriterion() {
                        Collection collection = (Collection)this.arguments[0];
                        if (collection == null || collection.isEmpty()) {
                            return FORCE_NO_RESULTS;
                        }
                        return Restrictions.in((String)this.propertyName, (Collection)collection);
                    }
                };
            }
            if (queryParameter.endsWith(NOT_EQUAL)) {
                return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, NOT_EQUAL), NOT_EQUAL, 1, GrailsMethodExpression.isNegation(queryParameter, NOT_EQUAL)){

                    Criterion createCriterion() {
                        if (this.arguments[0] == null) {
                            return Restrictions.isNotNull((String)this.propertyName);
                        }
                        return Restrictions.ne((String)this.propertyName, (Object)this.arguments[0]);
                    }
                };
            }
            return new GrailsMethodExpression(application, (Class)clazz, GrailsMethodExpression.calcPropertyName(queryParameter, null), EQUAL, 1, GrailsMethodExpression.isNegation(queryParameter, EQUAL)){

                Criterion createCriterion() {
                    if (this.arguments[0] == null) {
                        return Restrictions.isNull((String)this.propertyName);
                    }
                    return Restrictions.eq((String)this.propertyName, (Object)this.arguments[0]);
                }
            };
        }

        private static boolean isNegation(String queryParameter, String clause) {
            String propName;
            if (clause != null && !clause.equals(EQUAL)) {
                int i = queryParameter.indexOf(clause);
                propName = queryParameter.substring(0, i);
            } else {
                propName = queryParameter;
            }
            return propName.endsWith(NOT);
        }

        private static String calcPropertyName(String queryParameter, String clause) {
            String propName;
            int i;
            if (clause != null && !clause.equals(EQUAL)) {
                i = queryParameter.indexOf(clause);
                propName = queryParameter.substring(0, i);
            } else {
                propName = queryParameter;
            }
            if (propName.endsWith(NOT)) {
                i = propName.lastIndexOf(NOT);
                propName = propName.substring(0, i);
            }
            return propName.substring(0, 1).toLowerCase(Locale.ENGLISH) + propName.substring(1);
        }
    }
}

