/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.keyvalue.engine;

import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.NativeEntryEntityPersister;
import org.grails.datastore.mapping.keyvalue.mapping.config.Family;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValue;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.springframework.context.ApplicationEventPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyValueEntityPersister<T, K>
extends NativeEntryEntityPersister<T, K> {
    protected String entityFamily;

    protected AbstractKeyValueEntityPersister(MappingContext context, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(context, entity, session, publisher);
        this.entityFamily = this.getFamily(entity, this.classMapping);
    }

    @Override
    public String getEntityFamily() {
        return this.entityFamily;
    }

    @Override
    public ClassMapping getClassMapping() {
        return this.classMapping;
    }

    @Override
    protected String getNativePropertyKey(PersistentProperty prop) {
        PropertyMapping pm = prop.getMapping();
        String propKey = null;
        if (pm.getMappedForm() != null) {
            propKey = ((KeyValue)pm.getMappedForm()).getKey();
        }
        if (propKey == null) {
            propKey = prop.getName();
        }
        return propKey;
    }

    protected String getFamily(PersistentEntity persistentEntity, ClassMapping<Family> cm) {
        String table = null;
        if (cm.getMappedForm() != null) {
            table = cm.getMappedForm().getFamily();
        }
        if (table == null) {
            table = persistentEntity.getJavaClass().getName();
        }
        return table;
    }

    protected String getKeyspace(ClassMapping<Family> cm, String defaultValue) {
        String keyspace = null;
        if (cm.getMappedForm() != null) {
            keyspace = cm.getMappedForm().getKeyspace();
        }
        if (keyspace == null) {
            keyspace = defaultValue;
        }
        return keyspace;
    }
}

