/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.LocaleMacro;
import org.radeox.macro.Preserved;
import org.radeox.util.i18n.ResourceManager;

public abstract class LocalePreserved
extends Preserved
implements LocaleMacro {
    private static Log log = LogFactory.getLog(LocalePreserved.class);
    private String name;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        try {
            return ResourceManager.getBundle((String)this.initialContext.get("RenderContext.language_bundle_name")).getString(this.getLocaleKey() + ".description");
        }
        catch (Exception e) {
            log.warn((Object)("missing macro description for " + this.getLocaleKey()));
            return super.getDescription();
        }
    }

    public String[] getParamDescription() {
        try {
            return ResourceManager.getBundle((String)this.initialContext.get("RenderContext.language_bundle_name")).getString(this.getLocaleKey() + ".params").split(";");
        }
        catch (Exception e) {
            return super.getParamDescription();
        }
    }

    public void setInitialContext(InitialRenderContext context) {
        super.setInitialContext(context);
        Locale languageLocale = (Locale)context.get("RenderContext.language_locale");
        String languageName = (String)context.get("RenderContext.language_bundle_name");
        ResourceBundle messages = ResourceBundle.getBundle(languageName, languageLocale);
        Locale inputLocale = (Locale)context.get("RenderContext.input_locale");
        String inputName = (String)context.get("RenderContext.input_bundle_name");
        ResourceBundle inputMessages = ResourceBundle.getBundle(inputName, inputLocale);
        this.name = inputMessages.getString(this.getLocaleKey() + ".name");
        try {
            this.description = messages.getString(this.getLocaleKey() + ".description");
        }
        catch (Exception e) {
            log.warn((Object)("Cannot read description from properties " + inputName + " for " + this.getLocaleKey()));
        }
    }
}

