/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.RuntimeTypeInformation;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public interface TypeInformation<T>
extends TypeVariableResolver,
AnnotationMetadataProvider,
Type {
    @NonNull
    public Class<T> getType();

    default public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    default public Class<?> getWrapperType() {
        if (this.isPrimitive()) {
            return ReflectionUtils.getWrapperType(this.getType());
        }
        return this.getType();
    }

    @Override
    @NonNull
    default public String getTypeName() {
        Object[] typeParameters = this.getTypeParameters();
        if (ArrayUtils.isNotEmpty(typeParameters)) {
            String typeName = this.getType().getTypeName();
            return typeName + "<" + Arrays.stream(typeParameters).map(TypeInformation::getTypeName).collect(Collectors.joining(",")) + ">";
        }
        return this.getType().getTypeName();
    }

    default public boolean isReactive() {
        return RuntimeTypeInformation.isReactive(this.getType());
    }

    default public boolean isWrapperType() {
        return RuntimeTypeInformation.isWrapperType(this.getType());
    }

    default public Argument<?> getWrappedType() {
        return RuntimeTypeInformation.getWrappedType(this);
    }

    default public boolean isCompletable() {
        return RuntimeTypeInformation.isCompletable(this.getType());
    }

    default public boolean isAsync() {
        Class<T> type = this.getType();
        return CompletionStage.class.isAssignableFrom(type);
    }

    default public boolean isAsyncOrReactive() {
        return this.isAsync() || this.isReactive();
    }

    default public boolean isContainerType() {
        Class<T> type = this.getType();
        return Map.class == type || DefaultArgument.CONTAINER_TYPES.contains(type);
    }

    default public boolean hasTypeVariables() {
        return !this.getTypeVariables().isEmpty();
    }

    default public String getTypeString(boolean simple) {
        Class<T> type = this.getType();
        StringBuilder returnType = new StringBuilder(simple ? type.getSimpleName() : type.getName());
        Map<String, Argument<?>> generics = this.getTypeVariables();
        if (!generics.isEmpty()) {
            returnType.append("<").append(generics.values().stream().map(arg -> arg.getTypeString(simple)).collect(Collectors.joining(", "))).append(">");
        }
        return returnType.toString();
    }

    default public boolean isVoid() {
        Class<T> javaReturnType = this.getType();
        if (javaReturnType == Void.TYPE) {
            return true;
        }
        if (this.isCompletable()) {
            return true;
        }
        if (this.isReactive() || this.isAsync()) {
            return this.getFirstTypeVariable().filter(arg -> arg.getType() == Void.class).isPresent();
        }
        return false;
    }

    default public boolean isOptional() {
        Class<T> type = this.getType();
        return type == Optional.class;
    }

    default public boolean isSpecifiedSingle() {
        return RuntimeTypeInformation.isSpecifiedSingle(this);
    }

    @NonNull
    default public ParameterizedType asParameterizedType() {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return TypeInformation.this.getTypeParameters();
            }

            @Override
            public Type getRawType() {
                return TypeInformation.this.getType();
            }

            @Override
            public Type getOwnerType() {
                return TypeInformation.this;
            }

            @Override
            public String getTypeName() {
                return TypeInformation.this.getTypeName();
            }

            public String toString() {
                return this.getTypeName();
            }
        };
    }

    default public boolean isArray() {
        return this.getType().isArray();
    }

    @NonNull
    default public String getSimpleName() {
        return this.getType().getSimpleName();
    }

    default public boolean isProvider() {
        for (String type : DefaultArgument.PROVIDER_TYPES) {
            if (!this.getType().getName().equals(type)) continue;
            return true;
        }
        return false;
    }
}

