/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.testng.TestNGException;
import org.testng.internal.reflect.Parameter;
import org.testng.internal.reflect.ReflectionRecipes;

public class MethodMatcherException
extends TestNGException {
    public MethodMatcherException(String message, Method method, Object[] args) {
        this(MethodMatcherException.generateMessage(message, method, args));
    }

    public MethodMatcherException(String message) {
        super(message);
    }

    public MethodMatcherException(String message, Throwable cause) {
        super(message, cause);
    }

    public MethodMatcherException(Throwable cause) {
        super(cause);
    }

    static String generateMessage(String message, Constructor constructor, Object[] args) {
        Parameter[] parameter = null;
        String name = null;
        if (constructor != null) {
            parameter = ReflectionRecipes.getConstructorParameters(constructor);
            name = constructor.getName();
        }
        return MethodMatcherException.generateMessage(message, name, "Constructor", parameter, args);
    }

    public static String generateMessage(String message, Method method, Object[] args) {
        Parameter[] parameter = null;
        String name = null;
        if (method != null) {
            parameter = ReflectionRecipes.getMethodParameters(method);
            name = method.getName();
        }
        return MethodMatcherException.generateMessage(message, name, "Method", parameter, args);
    }

    private static String generateMessage(String message, String name, String prefix, Parameter[] parameter, Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append("\n").append(prefix).append(": ");
        if (name != null) {
            sb.append(name).append("(").append(Arrays.toString(parameter)).append(")");
        } else {
            sb.append("null");
        }
        sb.append("\n").append("Arguments: ");
        if (args != null) {
            sb.append("[");
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg != null) {
                    sb.append("(").append(arg.getClass().getName()).append(") ").append(MethodMatcherException.stringify(arg));
                } else {
                    sb.append("null");
                }
                if (i >= args.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        } else {
            sb.append("Arguments: null");
        }
        return sb.toString();
    }

    private static String stringify(Object object) {
        if (object.getClass().isArray()) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }
}

