/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.collections;

import java.util.Collection;
import org.multiverse.api.Stm;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.collections.TxnCollection;
import org.multiverse.api.collections.TxnIterator;
import org.multiverse.api.references.TxnRefFactory;

public abstract class AbstractTxnCollection<E>
implements TxnCollection<E> {
    protected final Stm stm;
    protected final TxnRefFactory defaultRefFactory;

    protected AbstractTxnCollection(Stm stm) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        this.defaultRefFactory = stm.getDefaultRefFactory();
    }

    @Override
    public Stm getStm() {
        return this.stm;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public boolean isEmpty(Txn tx) {
        return this.size(tx) == 0;
    }

    @Override
    public int size() {
        return this.size(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public void clear() {
        this.clear(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public boolean contains(Object item) {
        return this.contains(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.containsAll(TxnThreadLocal.getThreadLocalTxn(), c);
    }

    @Override
    public boolean containsAll(Txn tx, Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return true;
        }
        if (this.isEmpty(tx)) {
            return false;
        }
        for (Object item : c) {
            if (this.contains(tx, item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(TxnThreadLocal.getThreadLocalTxn(), o);
    }

    @Override
    public boolean add(E item) {
        return this.add(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(TxnThreadLocal.getThreadLocalTxn(), c);
    }

    @Override
    public boolean addAll(Txn tx, Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return false;
        }
        boolean change = false;
        for (E item : c) {
            if (!this.add(tx, item)) continue;
            change = true;
        }
        return change;
    }

    @Override
    public boolean addAll(TxnCollection<? extends E> c) {
        return this.addAll(TxnThreadLocal.getThreadLocalTxn(), c);
    }

    @Override
    public boolean addAll(Txn tx, TxnCollection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty(tx)) {
            return false;
        }
        boolean change = false;
        TxnIterator it = c.iterator(tx);
        while (it.hasNext(tx)) {
            if (!this.add(tx, it.next(tx))) continue;
            change = true;
        }
        return change;
    }

    @Override
    public TxnIterator<E> iterator() {
        return this.iterator(TxnThreadLocal.getThreadLocalTxn());
    }

    public String toString() {
        return this.toString(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }
}

