/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.StringUtils;

public class PackageSplitJarProcessor
implements JarProcessor<Set<String>> {
    private static final String MODULE_INFO = "module-info.class";
    private static final String VERSIONED = "META-INF/versions/";
    private final JarFileResolver jarFileResolver;

    public PackageSplitJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Set<String>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Set<String>>> set = new TreeSet<JarProcessor.JarFileResult<Set<String>>>();
        PackageCounter packageCounter = new PackageCounter();
        PackageTracker packageTracker = new PackageTracker();
        Set<JarFile> jarFiles = this.jarFileResolver.resolveJarFiles();
        if (jarFiles.size() < 2) {
            throw new JarvizException(RB.$("ERROR_NOT_ENOUGH_INPUT_JARS", "2"));
        }
        for (JarFile jarFile : jarFiles) {
            try {
                JarFile jarFile2 = jarFile;
                try {
                    jarFile.stream().map(ZipEntry::getName).filter(entryName -> entryName.endsWith(".class") && !entryName.startsWith(VERSIONED) && !entryName.equals(MODULE_INFO)).map(this::asPackage).distinct().sorted().forEach(thePackage -> {
                        packageCounter.add((String)thePackage);
                        packageTracker.add(jarFile, (String)thePackage);
                    });
                }
                finally {
                    if (jarFile2 == null) continue;
                    jarFile2.close();
                }
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_OPENING_JAR", jarFile.getName()));
            }
        }
        packageCounter.cleanup();
        packageTracker.cleanup(packageCounter.packages.keySet());
        for (Map.Entry entry : packageTracker.packages.entrySet()) {
            Set splitPackages = (Set)entry.getValue();
            if (splitPackages.isEmpty()) continue;
            set.add(JarProcessor.JarFileResult.of((JarFile)entry.getKey(), new TreeSet(splitPackages)));
        }
        return set;
    }

    private String asPackage(String name) {
        int i = name.lastIndexOf(47);
        return i != -1 ? name.substring(0, i).replace('/', '.') : "";
    }

    private static class PackageTracker {
        private final Map<JarFile, Set<String>> packages = new LinkedHashMap<JarFile, Set<String>>();

        private PackageTracker() {
        }

        private void add(JarFile jarFile, String thePackage) {
            if (StringUtils.isNotBlank(thePackage)) {
                this.packages.computeIfAbsent(jarFile, k -> new TreeSet()).add(thePackage);
            }
        }

        private void cleanup(Set<String> splitPackages) {
            for (Set<String> packagerPerJar : this.packages.values()) {
                packagerPerJar.retainAll(splitPackages);
            }
        }
    }

    private static class PackageCounter {
        private static final Integer ZERO = 0;
        private final Map<String, Integer> packages = new LinkedHashMap<String, Integer>();

        private PackageCounter() {
        }

        private void add(String thePackage) {
            if (StringUtils.isNotBlank(thePackage)) {
                Integer count = this.packages.computeIfAbsent(thePackage, k -> ZERO);
                this.packages.put(thePackage, count + 1);
            }
        }

        private void cleanup() {
            for (String key : new TreeSet<String>(this.packages.keySet())) {
                if (this.packages.get(key) != 1) continue;
                this.packages.remove(key);
            }
        }
    }
}

