/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.resolvers;

import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.kordamp.jarviz.core.resolvers.ClasspathBasedJarFileResolver;
import org.kordamp.jarviz.core.resolvers.CompositeJarFileResolver;
import org.kordamp.jarviz.core.resolvers.DirectoryBasedJarFileResolver;
import org.kordamp.jarviz.core.resolvers.GavBasedJarFileResolver;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.core.resolvers.PathBasedJarFileResolver;
import org.kordamp.jarviz.core.resolvers.UrlBasedJarFileResolver;
import org.kordamp.jarviz.util.StringUtils;

public class JarFileResolvers {
    public static JarFileResolver createJarFileResolver(Path file, String gav, URL url, Path cacheDirectory) {
        if (file != null) {
            return new PathBasedJarFileResolver(file);
        }
        if (StringUtils.isNotBlank(gav)) {
            return new GavBasedJarFileResolver(cacheDirectory, gav);
        }
        return new UrlBasedJarFileResolver(cacheDirectory, url);
    }

    public static Set<JarFileResolver> classpathJarFileResolvers(Collection<String> classpaths) {
        if (classpaths.isEmpty()) {
            return Collections.emptySet();
        }
        return classpaths.stream().map(ClasspathBasedJarFileResolver::new).collect(Collectors.toSet());
    }

    public static Set<JarFileResolver> directoryJarFileResolvers(Collection<Path> directories) {
        if (directories.isEmpty()) {
            return Collections.emptySet();
        }
        return directories.stream().map(DirectoryBasedJarFileResolver::new).collect(Collectors.toSet());
    }

    public static Set<JarFileResolver> pathJarFileResolvers(Collection<Path> files) {
        if (files.isEmpty()) {
            return Collections.emptySet();
        }
        return files.stream().map(PathBasedJarFileResolver::new).collect(Collectors.toSet());
    }

    public static Set<JarFileResolver> gavJarFileResolvers(Path cacheDirectory, Collection<String> gavs) {
        if (gavs.isEmpty()) {
            return Collections.emptySet();
        }
        return gavs.stream().map(gav -> new GavBasedJarFileResolver(cacheDirectory, (String)gav)).collect(Collectors.toSet());
    }

    public static Set<JarFileResolver> urlJarFileResolvers(Path cacheDirectory, Collection<URL> urls) {
        if (urls.isEmpty()) {
            return Collections.emptySet();
        }
        return urls.stream().map(url -> new UrlBasedJarFileResolver(cacheDirectory, (URL)url)).collect(Collectors.toSet());
    }

    public static JarFileResolver compositeJarFileResolver(Set<JarFileResolver> resolvers) {
        return new CompositeJarFileResolver(resolvers);
    }
}

